<?php
session_save_path(__DIR__ . '/../tmp');
if (!is_dir(__DIR__ . '/../tmp')) mkdir(__DIR__ . '/../tmp', 0777, true);
session_start();

if (!isset($_SESSION['user_id'])) {
  header("Location: /wood-system/login.php");
  exit;
}

require __DIR__ . '/../includes/db.php';
require __DIR__ . '/../includes/header.php';

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

/* ========================== تصدير Excel (نسخة احترافية) ========================== */
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['export_excel'])) {
    if (ob_get_length()) ob_end_clean();
    require __DIR__ . '/../vendor/autoload.php';

    $cust_id = (int)$_POST['customer_id'];

    // اسم العميل
    $stmt = $pdo->prepare("SELECT name FROM customers WHERE id=?");
    $stmt->execute([$cust_id]);
    $cust_name = $stmt->fetchColumn() ?: 'عميل غير معروف';

    /* ================= جمع كل الحركات ================= */
    $movements = [];

    // فواتير المبيعات + البنود
    $q1 = $pdo->prepare("
        SELECT si.id, si.date, si.total, 'invoice' AS type
        FROM sales_invoices si
        WHERE si.customer_id = ?
    ");
    $q1->execute([$cust_id]);
    foreach ($q1 as $r) {
        $r['items'] = $pdo->query("
            SELECT p.name, i.qty, i.price, i.total
            FROM sales_items i
            JOIN products p ON p.id = i.product_id
            WHERE i.invoice_id = {$r['id']}
        ")->fetchAll();
        $movements[] = $r;
    }

    // قبض من العميل
    $q2 = $pdo->prepare("SELECT id, date, amount, note, 'in' AS type FROM customer_money WHERE customer_id=? AND type='in'");
    $q2->execute([$cust_id]);
    foreach ($q2 as $r) { $movements[] = $r; }

    // دفع عن العميل (أجار – نقل – مصاريف)
    $q3 = $pdo->prepare("SELECT id, date, amount, note, 'out' AS type FROM customer_money WHERE customer_id=? AND type='out'");
    $q3->execute([$cust_id]);
    foreach ($q3 as $r) { $movements[] = $r; }

    usort($movements, fn($a,$b) => strcmp($a['date'], $b['date']));

    /* ================= إنشاء ملف Excel ================= */
    $spreadsheet = new Spreadsheet();
    $sheet = $spreadsheet->getActiveSheet();
    $sheet->setTitle('كشف حساب');

    /* === Header === */
    $sheet->setCellValue('A1', '📘 كشف حساب العميل: ' . $cust_name);
    $sheet->mergeCells('A1:G1');
    $sheet->getStyle('A1')->getFont()->setBold(true)->setSize(16);
    $sheet->getStyle('A1')->getFill()->setFillType('solid')->getStartColor()->setARGB('FFCCE5FF');

    /* === عناوين الجدول === */
    $sheet->fromArray(['التاريخ','البيان','المنتج','الكمية','السعر','مدين (+)','دائن (-)','الرصيد'], NULL, 'A3');
    $sheet->getStyle('A3:H3')->getFont()->setBold(true);
    $sheet->getStyle('A3:H3')->getFill()->setFillType('solid')->getStartColor()->setARGB('FF87CEEB'); // أزرق

    $row = 4;
    $balance = 0;
    $total_debit = 0;
    $total_credit = 0;

    foreach ($movements as $m){

        /* ============= فاتورة ============= */
        if ($m['type'] == 'invoice') {

            // عنوان الفاتورة
            $sheet->setCellValue("A{$row}", $m['date']);
            $sheet->setCellValue("B{$row}", "فاتورة مبيعات رقم {$m['id']}");
            $sheet->getStyle("A{$row}:H{$row}")->getFill()->setFillType('solid')->getStartColor()->setARGB('FFE6F2FF');
            $row++;

            // بنود الفاتورة
            foreach ($m['items'] as $it){
                $balance += $it['total'];
                $total_debit += $it['total'];

                $sheet->fromArray([
                    '',
                    '',
                    $it['name'],
                    $it['qty'],
                    number_format($it['price'],2),
                    $it['total'],
                    0,
                    $balance
                ], NULL, "A{$row}");

                $sheet->getStyle("A{$row}:H{$row}")
                    ->getFill()->setFillType('solid')->getStartColor()->setARGB('FFF7FBFF'); // خلفية فاتحة

                $row++;
            }

            // فاصل بين الفواتير
            $sheet->getStyle("A{$row}:H{$row}")->getFill()->setFillType('solid')->getStartColor()->setARGB('FFD9D9D9');
            $row++;
            continue;
        }

        /* ============= قبض من العميل (دائن) ============= */
        if ($m['type'] == 'in'){
            $amount = $m['amount'];
            $balance -= $amount;
            $total_credit += $amount;

            $sheet->fromArray([
                $m['date'],
                "قبض من العميل - {$m['note']}",
                '',
                '',
                '',
                0,
                $amount,
                $balance
            ], NULL, "A{$row}");

            $sheet->getStyle("A{$row}:H{$row}")->getFill()
                  ->setFillType('solid')->getStartColor()->setARGB('FFE5FFCC'); // أخضر فاتح

            $row++;
            continue;
        }

        /* ============= دفع عن العميل (مدين) ============= */
        if ($m['type'] == 'out'){
            $amount = $m['amount'];
            $balance += $amount;
            $total_debit += $amount;

            $sheet->fromArray([
                $m['date'],
                "دفع عن العميل - {$m['note']}",
                '',
                '',
                '',
                $amount,
                0,
                $balance
            ], NULL, "A{$row}");

            $sheet->getStyle("A{$row}:H{$row}")->getFill()
                  ->setFillType('solid')->getStartColor()->setARGB('FFFFE5CC'); // برتقالي فاتح

            $row++;
            continue;
        }
    }

    /* ================= إجمالي نهائي ================= */
    $sheet->setCellValue("A{$row}", "الإجمالي:");
    $sheet->setCellValue("F{$row}", $total_debit);
    $sheet->setCellValue("G{$row}", $total_credit);
    $sheet->setCellValue("H{$row}", $total_debit - $total_credit);

    $sheet->getStyle("A{$row}:H{$row}")->getFont()->setBold(true);
    $sheet->getStyle("A{$row}:H{$row}")->getFill()->setFillType('solid')->getStartColor()->setARGB('FFC0C0C0');

    /* === ضبط الأعمدة === */
    foreach (range('A','H') as $col)
        $sheet->getColumnDimension($col)->setAutoSize(true);

    /* === إخراج الملف === */
    header('Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet');
    header('Content-Disposition: attachment; filename="كشف حساب - '.$cust_name.'.xlsx"');
    $writer = new Xlsx($spreadsheet);
    $writer->save('php://output');
    exit;
}


/* ========================== عرض الصفحة ========================== */
$cust_id = (int)($_GET['customer_id'] ?? 0);
$customers = $pdo->query("SELECT id,name FROM customers ORDER BY name")->fetchAll();
$movements = [];

if ($cust_id) {
  // فواتير المبيعات بالتفاصيل
  $q1 = $pdo->prepare("
    SELECT si.*, 'invoice' AS type, cb.name AS cashbox_name
    FROM sales_invoices si
    LEFT JOIN cashbox cb ON cb.id = si.cashbox_id
    WHERE si.customer_id = ?
  ");
  $q1->execute([$cust_id]);
  foreach($q1 as $r){
    $r['items'] = $pdo->query("
      SELECT p.name, i.qty, i.price, i.total
      FROM sales_items i
      JOIN products p ON p.id = i.product_id
      WHERE i.invoice_id = {$r['id']}
    ")->fetchAll();
    $movements[] = $r;
  }

  // قبض من العميل
  $q2 = $pdo->prepare("SELECT *, 'in' AS type FROM customer_money WHERE customer_id=? AND type='in'");
  $q2->execute([$cust_id]);
  foreach($q2 as $r){ $movements[] = $r; }

  // دفع للعميل
  $q3 = $pdo->prepare("SELECT *, 'out' AS type FROM customer_money WHERE customer_id=? AND type='out'");
  $q3->execute([$cust_id]);
  foreach($q3 as $r){ $movements[] = $r; }

  usort($movements, fn($a,$b)=>strcmp($a['date'],$b['date']));
}
?>

<h3 class="mb-3">📘 كشف حساب عميل</h3>

<form class="row g-3 mb-3">
  <div class="col-md-6">
    <label class="form-label">اختر العميل</label>
    <select name="customer_id" class="form-select" onchange="this.form.submit()">
      <option value="">— اختر —</option>
      <?php foreach($customers as $c): ?>
      <option value="<?= $c['id'] ?>" <?= $cust_id==$c['id']?'selected':'' ?>><?= htmlspecialchars($c['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
</form>

<?php if($cust_id): ?>
<form method="post">
  <input type="hidden" name="export_excel" value="1">
  <input type="hidden" name="customer_id" value="<?= $cust_id ?>">
  <button class="btn btn-success mb-3">📤 تصدير إلى Excel</button>
</form>

<div class="card shadow-sm"><div class="card-body p-0">
<div class="table-responsive">
<table class="table table-striped text-center align-middle mb-0">
<thead class="table-dark">
<tr>
  <th>التاريخ</th>
  <th>البيان / التفاصيل</th>
  <th>مدين</th>
  <th>دائن</th>
  <th>الرصيد</th>
</tr>
</thead>
<tbody>
<?php $run=0; $d=0; $c=0;
foreach($movements as $m):
  $debit = 0; // ابدأ بصفر
  $credit = 0; // ابدأ بصفر

  if ($m['type'] == 'invoice') {
    // فاتورة المبيعات (مستحقة على العميل) هي مدين
    $debit = $m['total'] ?? 0;

  } elseif ($m['type'] == 'in') {
    // قبض من العميل (نقص في الاستحقاق) هو دائن
    $credit = $m['amount'] ?? 0;

  } elseif ($m['type'] == 'out') {
    // دفع عن العميل (مستحق على العميل) هو مدين
    $debit = $m['amount'] ?? 0;

  } 
  // ملاحظة: منطق 'تحويل' لم يتم تضمينه لأنه عادةً ما يتم التعامل معه في 'in'/'out'
  // إذا كنت تتعامل مع حالة 'تحويل' مختلفة، أعد إدراجها هنا.

  $run += $debit - $credit; $d+=$debit; $c+=$credit;
?>
<tr>
  <td><?= htmlspecialchars($m['date']) ?></td>
  <td class="text-start">
    <?php if($m['type']=='invoice'): ?>
      <b>فاتورة رقم <?= htmlspecialchars($m['id']) ?></b><br>
      <span>طريقة الدفع: <?= htmlspecialchars($m['payment_type']) ?> | الصندوق: <?= htmlspecialchars($m['cashbox_name']) ?></span><br>
      <div class="bg-light p-2 mt-1 border rounded">
        <?php foreach($m['items'] as $it): ?>
          ➜ <?= htmlspecialchars($it['name']) ?> × <?= $it['qty'] ?> @ <?= number_format($it['price'],2) ?> = <b><?= number_format($it['total'],2) ?></b><br>
        <?php endforeach; ?>
      </div>
    <?php elseif($m['type']=='in'): ?>
      <b>قبض من العميل</b><br><?= htmlspecialchars($m['note'] ?? '') ?>
    <?php else: ?>
      <b>دفع للعميل</b><br><?= htmlspecialchars($m['note'] ?? '') ?>
    <?php endif; ?>
  </td>
  <td><?= number_format($debit,2) ?></td>
  <td><?= number_format($credit,2) ?></td>
  <td class="<?= $run<0?'text-danger':'text-success' ?> fw-bold"><?= number_format($run,2) ?></td>
</tr>
<?php endforeach; ?>
</tbody>
<tfoot>
<tr class="table-light">
  <th colspan="2">الإجمالي</th>
  <th><?= number_format($d,2) ?></th>
  <th><?= number_format($c,2) ?></th>
  <th><?= number_format($d-$c,2) ?></th>
</tr>
</tfoot>
</table>
</div></div></div>
<?php endif; ?>

<?php require __DIR__ . '/../includes/footer.php'; ?>
