<?php
// ✅ تعديل المستخدم
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_user'])) {
    $id = (int)$_POST['id'];
    $username = trim($_POST['username']);
    $full_name = trim($_POST['full_name']);
    $password = trim($_POST['password']);

    if ($password !== '') {
        $hash = md5($password);
        $pdo->prepare("UPDATE users SET username=?, full_name=?, password=? WHERE id=?")
            ->execute([$username, $full_name, $hash, $id]);
    } else {
        $pdo->prepare("UPDATE users SET username=?, full_name=? WHERE id=?")
            ->execute([$username, $full_name, $id]);
    }

    echo "<div class='alert alert-success mt-2'>✅ تم تحديث بيانات المستخدم بنجاح.</div>";
    echo "<script>localStorage.setItem('activeTab', '#users');</script>";
}

// ✅ حذف المستخدم
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    if ($id == 1) {
        echo "<div class='alert alert-danger mt-2'>🚫 لا يمكن حذف المستخدم الرئيسي (admin).</div>";
    } else {
        $pdo->prepare("DELETE FROM users WHERE id=?")->execute([$id]);
        echo "<div class='alert alert-warning mt-2'>🗑️ تم حذف المستخدم بنجاح.</div>";
    }
    echo "<script>localStorage.setItem('activeTab', '#users');</script>";
}

// ✅ جلب المستخدمين
$users = $pdo->query("SELECT * FROM users ORDER BY id ASC")->fetchAll(PDO::FETCH_ASSOC);
?>

<style>
.user-card {
  background: #ffffff;
  border-radius: 14px;
  padding: 25px;
  margin-bottom: 20px;
  box-shadow: 0 2px 10px rgba(0,0,0,0.05);
  transition: all .3s ease;
}
.user-card:hover {
  transform: translateY(-3px);
  box-shadow: 0 5px 16px rgba(0,0,0,0.1);
}
.user-actions {
  text-align: center;
}
.user-actions .btn {
  min-width: 110px;
  font-weight: 600;
  border-radius: 8px;
  padding: 6px 16px;
}
.btn-save {
  background-color: #198754;
  color: white;
}
.btn-save:hover { background-color: #157347; }

.btn-delete {
  background-color: #dc3545;
  color: white;
}
.btn-delete:hover { background-color: #bb2d3b; }
</style>

<div class="mt-3">
<?php foreach ($users as $u): ?>
  <div class="user-card">
    <form method="post">
      <div class="row g-3 align-items-center">
        <div class="col-md-3">
          <label class="form-label fw-semibold">اسم المستخدم</label>
          <input type="text" name="username" class="form-control" value="<?= htmlspecialchars($u['username']) ?>">
        </div>
        <div class="col-md-3">
          <label class="form-label fw-semibold">الاسم الكامل</label>
          <input type="text" name="full_name" class="form-control" value="<?= htmlspecialchars($u['full_name']) ?>">
        </div>
        <div class="col-md-3">
          <label class="form-label fw-semibold">كلمة مرور جديدة</label>
          <input type="password" name="password" class="form-control" placeholder="اختياري">
        </div>
        <div class="col-md-3">
          <label class="form-label fw-semibold">تاريخ الإنشاء</label>
          <input type="text" readonly class="form-control bg-light" value="<?= htmlspecialchars($u['created_at']) ?>">
        </div>
      </div>

      <div class="user-actions mt-4 d-flex justify-content-center gap-3">
        <input type="hidden" name="id" value="<?= $u['id'] ?>">
        <button class="btn btn-save" name="update_user">💾 حفظ</button>
        <?php if ($u['id'] != 1): ?>
        <a href="?delete=<?= $u['id'] ?>" 
           class="btn btn-delete"
           onclick="return confirm('هل أنت متأكد أنك تريد حذف المستخدم <?= htmlspecialchars($u['username']) ?> ؟')">
           🗑 حذف
        </a>
        <?php endif; ?>
      </div>
    </form>
  </div>
<?php endforeach; ?>
</div>

<?php if (empty($users)): ?>
  <div class="alert alert-secondary text-center mt-3">⚠️ لا يوجد مستخدمون بعد.</div>
<?php endif; ?>
