<?php
session_save_path(__DIR__ . '/../tmp');
if (!is_dir(__DIR__ . '/../tmp')) mkdir(__DIR__ . '/../tmp', 0777, true);
session_start();

if (!isset($_SESSION['user_id'])) {
  header("Location: /wood-system/login.php");
  exit;
}

require __DIR__ . '/../includes/db.php';
require __DIR__ . '/../includes/header.php';

$user_id = $_SESSION['user_id'];
$stmt = $pdo->prepare("SELECT * FROM users WHERE id=?");
$stmt->execute([$user_id]);
$current = $stmt->fetch(PDO::FETCH_ASSOC);
?>

<style>
.settings-container {
  max-width: 1100px;
  margin: auto;
}
.settings-card {
  border-radius: 16px;
  box-shadow: 0 4px 12px rgba(0,0,0,0.08);
  background: #fff;
  overflow: hidden;
}
.settings-sidebar {
  background: linear-gradient(135deg, #0d6efd, #002b80);
  color: #fff;
  min-height: 100%;
  padding: 20px;
}
.settings-sidebar h4 {
  font-weight: bold;
  text-align: center;
  margin-bottom: 30px;
}
.settings-sidebar .nav-link {
  color: #fff;
  font-size: 16px;
  border-radius: 10px;
  margin-bottom: 8px;
}
.settings-sidebar .nav-link.active {
  background: rgba(255,255,255,0.2);
  font-weight: bold;
}
.tab-content {
  background: #f8f9fa;
  border-radius: 0 16px 16px 0;
  padding: 25px;
  min-height: 500px;
}
h3.section-title {
  color: #0d6efd;
  font-weight: bold;
  border-bottom: 2px solid #0d6efd;
  display: inline-block;
  padding-bottom: 5px;
}
</style>

<div class="settings-container mt-4">
  <div class="settings-card d-flex flex-wrap">
    <div class="settings-sidebar col-md-3">
      <h4>⚙️ الإعدادات</h4>
      <nav class="nav flex-column" id="settingsTabs" role="tablist">
        <button class="nav-link active" id="profile-tab" data-bs-toggle="tab" data-bs-target="#profile" type="button" role="tab">👤 حسابي</button>
        <?php if (trim(strtolower($current['username'])) === 'admin'): ?>
        <button class="nav-link" id="users-tab" data-bs-toggle="tab" data-bs-target="#users" type="button" role="tab">👥 إدارة المستخدمين</button>
        <button class="nav-link" id="add-tab" data-bs-toggle="tab" data-bs-target="#add" type="button" role="tab">➕ إضافة مستخدم</button>
        <?php endif; ?>
      </nav>
    </div>

    <div class="tab-content col-md-9">
      <div class="tab-pane fade show active" id="profile" role="tabpanel">
        <h3 class="section-title mb-4">👤 تعديل بياناتي</h3>
        <?php include __DIR__ . '/settings/profile.php'; ?>
      </div>

      <?php if (trim(strtolower($current['username'])) === 'admin'): ?>
      <div class="tab-pane fade" id="users" role="tabpanel">
        <h3 class="section-title mb-4">👥 المستخدمون الحاليون</h3>
        <?php include __DIR__ . '/settings/manage_users.php'; ?>
      </div>

      <div class="tab-pane fade" id="add" role="tabpanel">
        <h3 class="section-title mb-4">➕ إضافة مستخدم جديد</h3>
        <?php include __DIR__ . '/settings/add_user.php'; ?>
      </div>
      <?php endif; ?>
    </div>
  </div>
</div>

<!-- ✅ حفظ آخر تبويب مفتوح -->
<script>
document.querySelectorAll('#settingsTabs button').forEach(btn => {
  btn.addEventListener('click', () => {
    localStorage.setItem('activeTab', btn.getAttribute('data-bs-target'));
  });
});

document.addEventListener('DOMContentLoaded', () => {
  const lastTab = localStorage.getItem('activeTab');
  if (lastTab) {
    const tabButton = document.querySelector(`[data-bs-target="${lastTab}"]`);
    if (tabButton) {
      const tab = new bootstrap.Tab(tabButton);
      tab.show();
    }
  }
});
</script>

<?php require __DIR__ . '/../includes/footer.php'; ?>
