<?php if (session_status()===PHP_SESSION_NONE) session_start(); ?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>Wood System Lite</title>

<!-- ✅ Bootstrap RTL + Icons -->
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.11.3/font/bootstrap-icons.css" rel="stylesheet">

<style>
:root {
  --main-blue: #0d6efd;
  --dark-blue: #003366;
  --light-bg: #f9fafc;
}
body {
  background: var(--light-bg);
  font-family: "Tajawal", "Segoe UI", sans-serif;
}
.navbar {
  background: linear-gradient(90deg, var(--dark-blue), var(--main-blue));
  box-shadow: 0 3px 10px rgba(0,0,0,0.1);
}
.nav-link {
  color: #f5f5f5 !important;
  margin-inline: .35rem;
  font-weight: 500;
  transition: all .3s ease;
  padding: 6px 14px !important;
  border-radius: .5rem;
}
.nav-link:hover { background: rgba(255,255,255,0.15); color:#fff !important; }
.nav-link.active {
  background:#fff !important; color:var(--main-blue) !important;
  font-weight:600; box-shadow:0 2px 5px rgba(0,0,0,.15);
}
.dropdown-menu {
  text-align: right;
  border-radius: .5rem;
  border: 1px solid #ddd;
  min-width: 13rem;
}
.dropdown-item { font-weight: 500; }
.dropdown-item:hover { background-color: var(--main-blue); color:#fff !important; }

/* لا نحتاج أي حيل تموضع إضافية الآن */
</style>
</head>

<body>
<nav class="navbar navbar-expand-lg navbar-dark">
  <div class="container-fluid">
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
      <span class="navbar-toggler-icon"></span>
    </button>

    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav me-auto mb-2 mb-lg-0 text-center">

        <!-- الرئيسية -->
        <li class="nav-item"><a class="nav-link" href="/wood-system/index.php">الرئيسية</a></li>

        <!-- الحسابات الرئيسية -->
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="mainAccountsDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            الحسابات الرئيسية
          </a>
          <ul class="dropdown-menu" aria-labelledby="mainAccountsDropdown">
            <li><a class="dropdown-item" href="/wood-system/pages/customers.php">العملاء</a></li>
            <li><a class="dropdown-item" href="/wood-system/pages/suppliers.php">الموردين</a></li>
            <li><a class="dropdown-item" href="/wood-system/pages/agents.php">المخلصين</a></li>
            <li><a class="dropdown-item" href="/wood-system/pages/products.php">المنتجات</a></li>
          </ul>
        </li>

        <!-- العمليات -->
        <li class="nav-item"><a class="nav-link" href="/wood-system/pages/purchases.php">المشتريات</a></li>
        <li class="nav-item"><a class="nav-link" href="/wood-system/pages/sales.php">المبيعات</a></li>
        <li class="nav-item"><a class="nav-link" href="/wood-system/pages/stock.php">المستودع</a></li>
        <li class="nav-item"><a class="nav-link" href="/wood-system/pages/money.php">المقبوضات</a></li>
        <li class="nav-item"><a class="nav-link" href="/wood-system/pages/payments.php">المدفوعات</a></li>
        <li class="nav-item"><a class="nav-link" href="/wood-system/pages/expenses.php">المصاريف</a></li>
        <li class="nav-item"><a class="nav-link" href="/wood-system/pages/cashbox.php">الصندوق</a></li>
        <li class="nav-item"><a class="nav-link" href="/wood-system/pages/transfers.php">حركات الحساب</a></li>

        <!-- الكشوفات -->
        <li class="nav-item dropdown">
          <a class="nav-link dropdown-toggle" href="#" id="statementsDropdown" role="button" data-bs-toggle="dropdown" aria-expanded="false">
            الكشوفات
          </a>
          <ul class="dropdown-menu" aria-labelledby="statementsDropdown">
            <li><a class="dropdown-item" href="/wood-system/pages/statement.php">كشف العملاء</a></li>
            <li><a class="dropdown-item" href="/wood-system/pages/supplier_statement.php">كشف الموردين</a></li>
            <li><a class="dropdown-item" href="/wood-system/pages/product_statement.php">كشف المواد</a></li>
            <li><a class="dropdown-item" href="/wood-system/pages/agent_statement.php">كشف المخلصين</a></li>
          </ul>
        </li>

        <!-- 👤 قائمة الملف الشخصي -->
        <li class="nav-item dropdown d-flex align-items-center">
          <a class="nav-link dropdown-toggle d-flex align-items-center justify-content-center"
             href="#" id="userMenu" role="button" data-bs-toggle="dropdown" aria-expanded="false"
             style="font-size:22px;color:#fff;">
            <i class="bi bi-person-circle"></i>
          </a>
          <!-- ملاحظة: dropdown-menu-end تعمل صح مع RTL في نسخة Bootstrap RTL -->
          <ul class="dropdown-menu dropdown-menu-end text-end shadow" aria-labelledby="userMenu">
            <li class="dropdown-header text-center fw-bold">
              <i class="bi bi-person-circle fs-4 text-primary"></i><br>
              <small><?= htmlspecialchars($_SESSION['username'] ?? 'غير معروف') ?></small>
            </li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item" href="/wood-system/pages/settings.php">⚙️ الإعدادات</a></li>
            <li><a class="dropdown-item" href="/wood-system/pages/settings.php#users">👥 إدارة المستخدمين</a></li>
            <li><a class="dropdown-item" href="/wood-system/pages/settings.php#add">➕ إضافة مستخدم</a></li>
            <li><hr class="dropdown-divider"></li>
            <li><a class="dropdown-item text-danger fw-bold" href="/wood-system/logout.php">🚪 تسجيل الخروج</a></li>
          </ul>
        </li>

      </ul>
    </div>
  </div>
</nav>

<div class="container py-4">
