<?php
session_save_path(__DIR__ . '/../tmp');
if (!is_dir(__DIR__ . '/../tmp')) mkdir(__DIR__ . '/../tmp', 0777, true);
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: /wood-system/login.php");
    exit;
}

require __DIR__ . '/../includes/db.php';
require __DIR__ . '/../includes/header.php';

// ✅ إضافة مستخدم جديد
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['add_user'])) {
    $username   = trim($_POST['username']);
    $full_name  = trim($_POST['full_name']);
    $password   = trim($_POST['password']);

    if ($username && $password) {
        $hash = md5($password); // النظام الحالي يستخدم MD5
        $stmt = $pdo->prepare("INSERT INTO users (username, password, full_name, created_at) VALUES (?,?,?,NOW())");
        $stmt->execute([$username, $hash, $full_name]);
        echo "<div class='alert alert-success text-center'>✅ تم إضافة المستخدم بنجاح.</div>";
    } else {
        echo "<div class='alert alert-danger text-center'>⚠️ يجب إدخال اسم مستخدم وكلمة مرور.</div>";
    }
}

// ✅ تعديل مستخدم
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['update_user'])) {
    $id         = (int)$_POST['id'];
    $username   = trim($_POST['username']);
    $full_name  = trim($_POST['full_name']);
    $password   = trim($_POST['password']);

    if ($password !== '') {
        $hash = md5($password);
        $stmt = $pdo->prepare("UPDATE users SET username=?, full_name=?, password=? WHERE id=?");
        $stmt->execute([$username, $full_name, $hash, $id]);
    } else {
        $stmt = $pdo->prepare("UPDATE users SET username=?, full_name=? WHERE id=?");
        $stmt->execute([$username, $full_name, $id]);
    }

    echo "<div class='alert alert-info text-center'>✏️ تم تعديل المستخدم بنجاح.</div>";
}

// ✅ حذف مستخدم (ما عدا الأدمن الرئيسي)
if (isset($_GET['delete'])) {
    $id = (int)$_GET['delete'];
    if ($id != 1) { // حماية المستخدم الرئيسي (admin)
        $pdo->prepare("DELETE FROM users WHERE id=?")->execute([$id]);
        echo "<div class='alert alert-warning text-center'>🗑 تم حذف المستخدم بنجاح.</div>";
    } else {
        echo "<div class='alert alert-danger text-center'>🚫 لا يمكن حذف المستخدم الرئيسي.</div>";
    }
}

// ✅ جلب المستخدمين
$users = $pdo->query("SELECT * FROM users ORDER BY id ASC")->fetchAll();
?>

<h3 class="mb-4">👥 إدارة المستخدمين</h3>

<!-- زر الإضافة -->
<div class="d-flex justify-content-end mb-3">
  <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#addModal">➕ إضافة مستخدم جديد</button>
</div>

<!-- جدول المستخدمين -->
<div class="card shadow-sm">
  <div class="card-body p-0">
    <table class="table table-striped align-middle text-center mb-0">
      <thead class="table-dark">
        <tr>
          <th>#</th>
          <th>اسم المستخدم</th>
          <th>الاسم الكامل</th>
          <th>تاريخ الإنشاء</th>
          <th>كلمة مرور جديدة</th>
          <th>تحكم</th>
        </tr>
      </thead>
      <tbody>
      <?php foreach ($users as $u): ?>
        <tr>
          <form method="post">
            <td><?= $u['id'] ?></td>
            <td><input type="text" name="username" value="<?= htmlspecialchars($u['username']) ?>" class="form-control"></td>
            <td><input type="text" name="full_name" value="<?= htmlspecialchars($u['full_name']) ?>" class="form-control"></td>
            <td><?= htmlspecialchars($u['created_at']) ?></td>
            <td>
              <input type="password" name="password" class="form-control" placeholder="اتركه فارغاً إن لم ترغب بتغييره">
            </td>
            <td class="d-flex justify-content-center gap-2">
              <input type="hidden" name="id" value="<?= $u['id'] ?>">
              <button class="btn btn-sm btn-success" name="update_user">💾 حفظ</button>
              <?php if ($u['id'] != 1): ?>
                <a href="?delete=<?= $u['id'] ?>" class="btn btn-sm btn-danger" onclick="return confirm('هل أنت متأكد من الحذف؟')">🗑 حذف</a>
              <?php endif; ?>
            </td>
          </form>
        </tr>
      <?php endforeach; ?>
      </tbody>
    </table>
  </div>
</div>

<!-- نافذة إضافة مستخدم جديد -->
<div class="modal fade" id="addModal" tabindex="-1">
  <div class="modal-dialog">
    <form method="post" class="modal-content">
      <div class="modal-header bg-primary text-white">
        <h5 class="modal-title">➕ إضافة مستخدم جديد</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
      </div>
      <div class="modal-body">
        <div class="mb-3">
          <label class="form-label">اسم المستخدم</label>
          <input type="text" name="username" class="form-control" required>
        </div>
        <div class="mb-3">
          <label class="form-label">الاسم الكامل</label>
          <input type="text" name="full_name" class="form-control">
        </div>
        <div class="mb-3">
          <label class="form-label">كلمة المرور</label>
          <input type="password" name="password" class="form-control" required>
        </div>
      </div>
      <div class="modal-footer">
        <button class="btn btn-primary" name="add_user">💾 حفظ</button>
      </div>
    </form>
  </div>
</div>

<?php require __DIR__ . '/../includes/footer.php'; ?>
