<?php
session_save_path(__DIR__ . '/../tmp');
if (!is_dir(__DIR__ . '/../tmp')) mkdir(__DIR__ . '/../tmp', 0777, true);
session_start();

if (!isset($_SESSION['user_id'])) {
    header("Location: /wood-system/login.php");
    exit;
}

require __DIR__ . '/../includes/db.php';
require __DIR__ . '/../includes/header.php';
if ($_SERVER['REQUEST_METHOD']==='POST'){
  $id = post('id');
  $name = trim(post('name'));
  $phone = trim(post('phone'));
  $address = trim(post('address'));
  if($id){
    $pdo->prepare("UPDATE customers SET name=?, phone=?, address=? WHERE id=?")->execute([$name,$phone,$address,$id]);
  }else{
    $pdo->prepare("INSERT INTO customers(name,phone,address) VALUES(?,?,?)")->execute([$name,$phone,$address]);
  }
  go('/wood-system/pages/customers.php');
}
if ($del=getv('delete')){ $pdo->prepare("DELETE FROM customers WHERE id=?")->execute([$del]); go('/wood-system/pages/customers.php'); }
$rows=$pdo->query("SELECT * FROM customers ORDER BY id DESC")->fetchAll();
?>
<div class="d-flex justify-content-between align-items-center mb-3">
  <h3 class="mb-0">العملاء</h3>
  <button class="btn btn-primary" data-bs-toggle="modal" data-bs-target="#m">➕ إضافة</button>
</div>
<div class="card shadow-sm"><div class="card-body p-0">
<div class="table-responsive"><table class="table table-striped mb-0 text-center align-middle">
<thead class="table-dark"><tr><th>#</th><th>الاسم</th><th>الهاتف</th><th>العنوان</th><th>إجراءات</th></tr></thead>
<tbody>
<?php foreach($rows as $r): ?>
<tr>
  <td><?= $r['id'] ?></td>
  <td><?= htmlspecialchars($r['name']) ?></td>
  <td><?= htmlspecialchars($r['phone']) ?></td>
  <td><?= htmlspecialchars($r['address']) ?></td>
  <td>
    <button class="btn btn-sm btn-outline-secondary" data-bs-toggle="modal" data-bs-target="#m"
      data-id="<?= $r['id'] ?>" data-name="<?= htmlspecialchars($r['name']) ?>"
      data-phone="<?= htmlspecialchars($r['phone']) ?>" data-address="<?= htmlspecialchars($r['address']) ?>">تعديل</button>
    <a class="btn btn-sm btn-outline-danger" href="?delete=<?= $r['id'] ?>" onclick="return confirm('حذف؟');">حذف</a>
  </td>
</tr>
<?php endforeach; ?>
</tbody></table></div></div>

<div class="modal fade" id="m" tabindex="-1"><div class="modal-dialog"><form method="post" class="modal-content">
  <div class="modal-header"><h5 class="modal-title">العميل</h5><button class="btn-close" data-bs-dismiss="modal"></button></div>
  <div class="modal-body row g-3">
    <input type="hidden" name="id" id="id">
    <div class="col-12"><label class="form-label">الاسم *</label><input class="form-control" name="name" id="name" required></div>
    <div class="col-12"><label class="form-label">الهاتف</label><input class="form-control" name="phone" id="phone"></div>
    <div class="col-12"><label class="form-label">العنوان</label><input class="form-control" name="address" id="address"></div>
  </div>
  <div class="modal-footer"><button class="btn btn-primary">حفظ</button></div>
</form></div></div>
<script>
const mm=document.getElementById('m');
mm.addEventListener('show.bs.modal',e=>{const b=e.relatedTarget;['id','name','phone','address'].forEach(k=>{
 document.getElementById(k).value=b&&b.dataset[k]?b.dataset[k]:'';
});});
</script>
<?php require __DIR__ . '/../includes/footer.php'; ?>
