<?php
require "../config.php";

function save_site_company($pdo, $name, $phone, $address, $city) {
    $sql = "INSERT INTO companies (source, name, phone, address, city)
            VALUES ('Turkish Sites', ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$name, $phone, $address, $city]);
}

// يمكن لاحقاً توسيعها لتشمل مدن أخرى أو بارامترات في الرابط
$sites = [
    [
        "url" => "https://www.firmasec.com/kategori/kuru-yemis-istanbul/",
        "city" => "İstanbul"
    ]
    // أضف روابط أخرى هنا
];

foreach ($sites as $s) {

    $url = $s["url"];
    $city = $s["city"];

    $html = @file_get_contents($url);
    if (!$html) continue;

    // هذه الأمثلة تقريبية، تحتاج تعديل حسب هيكل كل موقع
    preg_match_all('/<div class="firma-item">(.*?)<\/div>/s', $html, $blocks);

    foreach ($blocks[1] as $b) {

        preg_match('/<h2[^>]*>(.*?)<\/h2>/', $b, $name);
        preg_match('/Tel[^0-9]*([0-9\+\-\s]+)/', $b, $phone);
        preg_match('/Adres.*?<span[^>]*>(.*?)</s', $b, $address);

        $name    = isset($name[1]) ? trim(strip_tags($name[1])) : "";
        $phone   = isset($phone[1]) ? trim($phone[1]) : "";
        $address = isset($address[1]) ? trim(strip_tags($address[1])) : "";

        if ($name === "" && $phone === "" && $address === "") continue;

        save_site_company($pdo, $name, $phone, $address, $city);
    }
}

echo "Turkish sites scraping — Completed";
?>
