<?php
require "../config.php";

$cities = [
    "İstanbul","Ankara","İzmir","Bursa","Adana","Konya","Antalya","Gaziantep","Şanlıurfa",
    "Mersin","Diyarbakır","Kayseri","Samsun","Sakarya","Eskişehir","Trabzon","Malatya",
    "Erzurum","Van","Hatay","Manisa","Kahramanmaraş"
];

function save_company($pdo, $data) {
    $sql = "INSERT INTO companies (source, name, phone, address, city, website, rating, lat, lng)
            VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([
        $data['source'], $data['name'], $data['phone'], $data['address'],
        $data['city'], $data['website'], $data['rating'], $data['lat'], $data['lng']
    ]);
}

foreach ($cities as $city) {

    $query = "kuru yemişçi " . $city;
    $url = "https://maps.googleapis.com/maps/api/place/textsearch/json?query=" . urlencode($query) . "&key=" . $API_KEY;

    $json = @file_get_contents($url);
    if (!$json) continue;

    $data = json_decode($json, true);
    if (!isset($data['results'])) continue;

    foreach ($data['results'] as $place) {

        if (!isset($place["place_id"])) continue;

        $place_id = $place["place_id"];
        $details_url = "https://maps.googleapis.com/maps/api/place/details/json?place_id=" . urlencode($place_id) . "&key=" . $API_KEY;
        $details_json = @file_get_contents($details_url);
        if (!$details_json) continue;

        $details = json_decode($details_json, true);
        if (!isset($details["result"])) continue;

        $info = $details["result"];

        save_company($pdo, [
            "source"  => "Google Maps",
            "name"    => $info["name"] ?? "",
            "phone"   => $info["formatted_phone_number"] ?? "",
            "address" => $info["formatted_address"] ?? "",
            "city"    => $city,
            "website" => $info["website"] ?? "",
            "rating"  => isset($info["rating"]) ? (string)$info["rating"] : "",
            "lat"     => $info["geometry"]["location"]["lat"] ?? "",
            "lng"     => $info["geometry"]["location"]["lng"] ?? "",
        ]);
    }
}

echo "Google Maps Turkey — Completed";
?>
