<?php
require "../config.php";
auth_required();

$city = $_GET["city"] ?? "";
$search = $_GET["search"] ?? "";

$sql = "SELECT * FROM companies WHERE 1";

if ($city !== "") {
    $sql .= " AND city = " . $pdo->quote($city);
}

if ($search !== "") {
    $s = "%" . $search . "%";
    $sql .= " AND (name LIKE " . $pdo->quote($s) .
           " OR phone LIKE " . $pdo->quote($s) .
           " OR address LIKE " . $pdo->quote($s) . ")";
}

$sql .= " ORDER BY id DESC";

$companies = $pdo->query($sql)->fetchAll(PDO::FETCH_ASSOC);
$cities = $pdo->query("SELECT DISTINCT city FROM companies WHERE city IS NOT NULL AND city != '' ORDER BY city ASC")->fetchAll(PDO::FETCH_COLUMN);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>لوحة التحكم - trcompanies</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.rtl.min.css" rel="stylesheet">
</head>
<body class="bg-light">

<div class="container mt-4">

    <div class="d-flex justify-content-between align-items-center">
        <h3>شركات المكسرات — كل تركيا</h3>
        <div>
            <a href="/scrapers/run_all.php" class="btn btn-warning btn-sm">🔄 جمع جديد</a>
            <a href="/login/logout.php" class="btn btn-danger btn-sm">تسجيل خروج</a>
        </div>
    </div>

    <div class="card p-3 mt-3">

        <form class="row g-3" method="get">

            <div class="col-md-3">
                <label class="form-label">اختيار المدينة</label>
                <select name="city" class="form-select">
                    <option value="">كل المدن</option>
                    <?php foreach ($cities as $c): ?>
                        <option value="<?= htmlspecialchars($c) ?>" <?= $city==$c?"selected":"" ?>>
                            <?= htmlspecialchars($c) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <div class="col-md-4">
                <label class="form-label">بحث (اسم / هاتف / عنوان)</label>
                <input type="text" name="search" value="<?= htmlspecialchars($search) ?>" class="form-control">
            </div>

            <div class="col-md-2 d-flex align-items-end">
                <button class="btn btn-primary w-100">تطبيق</button>
            </div>

            <div class="col-md-2 d-flex align-items-end">
                <a href="export_excel.php" class="btn btn-success w-100">📥 تصدير Excel</a>
            </div>

        </form>
    </div>

    <div class="table-responsive mt-3">
        <table class="table table-bordered table-striped table-sm">
            <thead class="table-dark">
                <tr>
                    <th>#</th>
                    <th>المصدر</th>
                    <th>الاسم</th>
                    <th>الهاتف</th>
                    <th>المدينة</th>
                    <th>العنوان</th>
                    <th>موقع ويب</th>
                    <th>تقييم</th>
                    <th>خريطة</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($companies as $c): ?>
                <tr>
                    <td><?= (int)$c["id"] ?></td>
                    <td><?= htmlspecialchars($c["source"]) ?></td>
                    <td><?= htmlspecialchars($c["name"]) ?></td>
                    <td><?= htmlspecialchars($c["phone"]) ?></td>
                    <td><?= htmlspecialchars($c["city"]) ?></td>
                    <td><?= htmlspecialchars($c["address"]) ?></td>
                    <td>
                        <?php if(!empty($c["website"])): ?>
                            <a href="<?= htmlspecialchars($c["website"]) ?>" target="_blank">زيارة</a>
                        <?php endif; ?>
                    </td>
                    <td><?= htmlspecialchars($c["rating"]) ?></td>
                    <td>
                        <?php if(!empty($c["lat"])): ?>
                        <a target="_blank" href="https://maps.google.com/?q=<?= urlencode($c["lat"] . "," . $c["lng"]) ?>">عرض</a>
                        <?php endif; ?>
                    </td>
                </tr>
                <?php endforeach; ?>
                <?php if (empty($companies)): ?>
                <tr>
                    <td colspan="9" class="text-center">لا توجد بيانات بعد. اضغط "جمع جديد".</td>
                </tr>
                <?php endif; ?>
            </tbody>
        </table>
    </div>

</div>

</body>
</html>
