<?php
require "../config.php";
require "../vendor/autoload.php"; // تأكد من تثبيت PhpSpreadsheet عبر Composer

use PhpOffice\PhpSpreadsheet\Spreadsheet;
use PhpOffice\PhpSpreadsheet\Writer\Xlsx;

$spreadsheet = new Spreadsheet();
$sheet = $spreadsheet->getActiveSheet();

$sheet->fromArray(
    ["Source","Name","Phone","City","Address","Website","Rating","Lat","Lng"],
    NULL,
    'A1'
);

$data = $pdo->query("SELECT source,name,phone,city,address,website,rating,lat,lng FROM companies ORDER BY id DESC")
            ->fetchAll(PDO::FETCH_ASSOC);

$row = 2;
foreach ($data as $d) {
    $sheet->fromArray(array_values($d), NULL, "A{$row}");
    $row++;
}

$writer = new Xlsx($spreadsheet);
$filename = "Turkey_Nuts_Companies.xlsx";

header("Content-Type: application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
header("Content-Disposition: attachment; filename=\"" . $filename . "\"");
$writer->save("php://output");
exit;
?>
