<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include 'includes/functions.php';
require_once __DIR__ . '/generate_invoice_pdf.php';

// ✅ التحقق من وجود ID الفاتورة
if (!isset($_GET['id'])) {
    die("<div class='alert alert-danger text-center mt-5'>❌ لم يتم تحديد رقم الفاتورة.</div>");
}

$invoice_id = (int)$_GET['id'];

// ✅ جلب بيانات الفاتورة
$stmt = $pdo->prepare("SELECT * FROM invoices WHERE id=?");
$stmt->execute([$invoice_id]);
$invoice = $stmt->fetch();

if (!$invoice) {
    die("<div class='alert alert-danger text-center mt-5'>❌ الفاتورة غير موجودة.</div>");
}

// ✅ جلب بيانات العناصر
$stmtItems = $pdo->prepare("
    SELECT ii.*, p.name 
    FROM invoice_items ii
    LEFT JOIN products p ON ii.product_id = p.id
    WHERE ii.invoice_id=?
");
$stmtItems->execute([$invoice_id]);
$items = $stmtItems->fetchAll();

// ✅ جلب الشركات
$companies = $pdo->query("SELECT * FROM companies ORDER BY alici_adi ASC")->fetchAll();

// ====================================================================
// 🟩 عند الحفظ بعد التعديل
// ====================================================================
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $company_id = $_POST['company'] ?? null;
    $currency   = $_POST['currency'] ?? 'TL';
    $items      = $_POST['items'] ?? [];
    $quantities = $_POST['quantities'] ?? [];
    $prices     = $_POST['prices'] ?? [];

    $total = 0;

    // حذف العناصر القديمة
    $pdo->prepare("DELETE FROM invoice_items WHERE invoice_id=?")
        ->execute([$invoice_id]);

    // إعادة إدخال العناصر المعدلة
    foreach ($items as $i => $pid) {
        $qty   = (float)$quantities[$i];
        $price = (float)$prices[$i];

        $total += $qty * $price;

        $pdo->prepare("
            INSERT INTO invoice_items (invoice_id, product_id, quantity, price, cost_per_unit)
            VALUES (?,?,?,?,0)
        ")->execute([$invoice_id, $pid, $qty, $price]);
    }

    // تحديث بيانات الفاتورة
    $pdo->prepare("UPDATE invoices SET company_id=?, total=?, currency=? WHERE id=?")
        ->execute([$company_id, $total, $currency, $invoice_id]);

    // ============================================================
    // 🟦 توليد PDF جديد بعد الحفظ
    // ============================================================

    // 1️⃣ جلب بيانات الشركة
    $stmtC = $pdo->prepare("SELECT * FROM companies WHERE id=?");
    $stmtC->execute([$company_id]);
    $company = $stmtC->fetch();

    // 2️⃣ جلب العناصر الجديدة بصيغة مناسبة للـ PDF
    $stmtNewItems = $pdo->prepare("
        SELECT ii.quantity, ii.price, p.name
        FROM invoice_items ii
        LEFT JOIN products p ON ii.product_id = p.id
        WHERE ii.invoice_id=?
    ");
    $stmtNewItems->execute([$invoice_id]);
    $invoice_items = $stmtNewItems->fetchAll();

    // 3️⃣ إنشاء PDF جديد
    generateInvoicePDF($invoice_id, $company, $invoice_items, $total, $currency);

    // ============================================================

    echo "<div class='alert alert-success text-center mt-4'>
        ✅ تم تحديث الفاتورة بنجاح.<br>
        💵 الإجمالي الجديد: <b>{$total} {$currency}</b><br>
      <a href='invoices/invoice_{$invoice_id}.pdf?v=".time()."' target='_blank' class='btn btn-success mt-3'>📄 عرض PDF</a>

        <a href='invoices_pending.php' class='btn btn-secondary mt-3'>⬅️ الرجوع</a>
    </div>";
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>✏️ تعديل فاتورة رقم <?= $invoice_id ?></title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">

<!-- Select2 -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<script src="https://cdn.jsdelivr.net/npm/jquery@3.6.4/dist/jquery.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>

<style>
body { background-color: #f8f9fa; font-family: 'Cairo', sans-serif; }
h3 { color: #0d6efd; margin-bottom: 25px; font-weight:700; }
.card-form { background: #fff; padding: 25px; border-radius: 12px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); }
.invoice-item { display: flex; gap: 10px; margin-bottom: 12px; align-items: center; }
.select2-container .select2-selection--single {
    height: 38px; border-radius: 6px; border: 1px solid #ced4da;
}
</style>
</head>
<body>
<?php include 'includes/navbar.php'; ?>

<div class="container py-5">
    <div class="card-form">
        <h3 class="text-center">✏️ تعديل الفاتورة رقم <?= $invoice_id ?></h3>

        <form method="POST">

            <!-- الشركة -->
            <div class="mb-4">
                <label class="form-label">الشركة</label>
                <select id="companySelect" name="company" class="form-select" required>
                    <option value="">اختر الشركة...</option>
                    <?php foreach($companies as $c): 
                        $display_name = !empty($c['username']) ? $c['username'] : $c['alici_adi'];
                    ?>
                        <option value="<?= $c['id'] ?>" <?= $invoice['company_id']==$c['id']?'selected':'' ?>>
                            <?= htmlspecialchars($display_name) ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>

            <!-- المنتجات -->
            <div id="items-container">
                <?php foreach ($items as $it): ?>
                <div class="invoice-item">
                    <select name="items[]" class="form-select" required style="flex:3">
                        <option value="">اختر المادة</option>
                        <?php foreach($pdo->query("SELECT * FROM products") as $p): ?>
                        <option value="<?= $p['id'] ?>" <?= $p['id']==$it['product_id']?'selected':'' ?>>
                            <?= htmlspecialchars($p['name']) ?> (مخزون: <?= $p['stock'] ?>)
                        </option>
                        <?php endforeach; ?>
                    </select>

                    <input type="number" name="quantities[]" value="<?= $it['quantity'] ?>" class="form-control" required style="flex:1;" step="0.01">
                    <input type="number" name="prices[]" value="<?= $it['price'] ?>" class="form-control" required style="flex:1;" step="0.01">
                    <button type="button" class="btn btn-outline-danger" onclick="removeItem(this)">❌</button>
                </div>
                <?php endforeach; ?>
            </div>

            <button type="button" class="btn btn-outline-primary mb-3" onclick="addItem()">➕ إضافة منتج</button>

            <div class="mb-4">
                <label class="form-label">العملة</label>
                <select name="currency" class="form-select">
                    <option value="TL" <?= $invoice['currency']=='TL'?'selected':'' ?>>ليرة تركية (TL)</option>
                    <option value="USD" <?= $invoice['currency']=='USD'?'selected':'' ?>>دولار ($)</option>
                </select>
            </div>

            <button type="submit" class="btn btn-primary w-100">💾 حفظ التعديلات</button>
        </form>
    </div>
</div>

<script>
// تفعيل Select2
$(document).ready(function() {
    $('#companySelect').select2({
        placeholder: 'ابحث عن الشركة أو اليوزر...',
        width: '100%',
        allowClear: true,
        language: { noResults: () => "لا توجد نتائج" }
    });
});

// إضافة منتج
function addItem() {
    const container = document.getElementById('items-container');
    const first = container.children[0];
    const clone = first.cloneNode(true);
    
    clone.querySelectorAll('input').forEach(i => i.value = '');
    clone.querySelector('select').selectedIndex = 0;

    container.appendChild(clone);
}

// حذف منتج
function removeItem(btn){
    const container = document.getElementById('items-container');
    if(container.children.length > 1){
        btn.closest('.invoice-item').remove();
    } else {
        alert('يجب أن تحتوي الفاتورة على منتج واحد على الأقل');
    }
}
</script>

</body>
</html>
