<?php
// عرض الأخطاء لتشخيص أي مشكلة
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);

session_start();
include 'includes/functions.php';

// الاتصال بقاعدة البيانات
$host = "localhost";
$dbname = "deltaweb_invoice";
$username = "deltaweb_invoice";
$password = "deltaweb_invoice";

try {
    $pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8mb4", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
} catch (PDOException $e) {
    die("❌ فشل الاتصال بقاعدة البيانات: " . $e->getMessage());
}

// تحميل مكتبة SimpleXLSX
require_once __DIR__ . "/includes/simplexlsx-master/src/SimpleXLSX.php";

// ======================= إضافة مادة جديدة =======================
if (isset($_POST['add'])) {
    $name = trim($_POST['name']);
    $stock = (int)($_POST['stock'] ?? 0);

    if ($name !== '') {
        $stmt = $pdo->prepare("SELECT id FROM products WHERE name = ?");
        $stmt->execute([$name]);
        $exists = $stmt->fetchColumn();

        if ($exists) {
            $pdo->prepare("UPDATE products SET stock = stock + ? WHERE id = ?")->execute([$stock, $exists]);
        } else {
            $pdo->prepare("INSERT INTO products (name, stock, unit) VALUES (?, ?, 'KG')")->execute([$name, $stock]);
        }
    }
    header("Location: products.php");
    exit;
}

// ======================= تعديل المخزون =======================
if (isset($_POST['update_stock'])) {
    $id = (int)($_POST['id'] ?? 0);
    $amount = (int)($_POST['amount'] ?? 0);
    $action = $_POST['action'] ?? '';

    if ($amount > 0) {
        if ($action === 'increase') {
            $pdo->prepare("UPDATE products SET stock = stock + ? WHERE id = ?")->execute([$amount, $id]);
        } elseif ($action === 'decrease') {
            $pdo->prepare("UPDATE products SET stock = GREATEST(stock - ?, 0) WHERE id = ?")->execute([$amount, $id]);
        }
    }
    header("Location: products.php");
    exit;
}

// ======================= رفع Excel =======================
if (isset($_POST['upload'])) {
    if (is_uploaded_file($_FILES['excel']['tmp_name'])) {
        if ($xlsx = SimpleXLSX::parse($_FILES['excel']['tmp_name'])) {
            foreach ($xlsx->rows() as $index => $row) {
                if ($index == 0) continue; // تخطي الصف الأول (العناوين)
                $name = trim($row[0] ?? '');
                $stock = (int)($row[1] ?? 0);
                if ($name === '') continue;

                $stmt = $pdo->prepare("SELECT id FROM products WHERE name = ?");
                $stmt->execute([$name]);
                $id = $stmt->fetchColumn();

                if ($id) {
                    // تحديث المخزون الحالي
                    $pdo->prepare("UPDATE products SET stock = stock + ? WHERE id = ?")->execute([$stock, $id]);
                } else {
                    // إضافة مادة جديدة
                    $pdo->prepare("INSERT INTO products (name, stock, unit) VALUES (?, ?, 'KG')")->execute([$name, $stock]);
                }
            }
        }
    }
    header("Location: products.php");
    exit;
}

// ======================= تصدير Excel (CSV UTF-8) =======================
if (isset($_POST['export'])) {
    header("Content-Type: text/csv; charset=UTF-8");
    header("Content-Disposition: attachment; filename=products_export.csv");
    echo "\xEF\xBB\xBF"; // BOM لتفعيل UTF-8 في Excel

    echo "الاسم,المخزون,الوحدة\n";
    $rows = $pdo->query("SELECT name, stock, unit FROM products ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
    foreach ($rows as $r) {
        $name = str_replace(',', '،', $r['name']); // تجنب الفواصل
        echo "{$name},{$r['stock']},{$r['unit']}\n";
    }
    exit;
}

// ======================= عرض فواتير مادة معينة =======================
if (isset($_GET['view_invoices']) && is_numeric($_GET['view_invoices'])) {
    $product_id = intval($_GET['view_invoices']);

    // جلب المادة
    $stmt = $pdo->prepare("SELECT * FROM products WHERE id = ?");
    $stmt->execute([$product_id]);
    $product = $stmt->fetch(PDO::FETCH_ASSOC);
    if (!$product) die("❌ المادة غير موجودة");

    // جلب الفواتير
    $stmt = $pdo->prepare("
        SELECT i.id AS invoice_id, i.company_name AS customer_name, i.created_at AS date, ii.quantity, ii.price
        FROM invoice_items ii
        JOIN invoices i ON ii.invoice_id = i.id
        WHERE ii.product_id = ?
        ORDER BY i.created_at DESC
    ");
    $stmt->execute([$product_id]);
    $invoices = $stmt->fetchAll(PDO::FETCH_ASSOC);

    ?>
    <!DOCTYPE html>
    <html lang="ar">
    <head>
    <meta charset="UTF-8">
    <title>فواتير المادة <?= htmlspecialchars($product['name'] ?? '-') ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
    </head>
    <body dir="rtl" class="bg-light">
    <div class="container py-4">
        <h3>📄 فواتير المادة: <?= htmlspecialchars($product['name'] ?? '-') ?></h3>
        <a href="products.php" class="btn btn-secondary mb-3">⬅️ رجوع</a>

        <?php if (!empty($invoices)): ?>
            <table class="table table-bordered table-striped text-center bg-white">
                <thead class="table-dark">
                    <tr>
                        <th>رقم الفاتورة</th>
                        <th>العميل</th>
                        <th>الكمية</th>
                        <th>السعر</th>
                        <th>التاريخ</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($invoices as $inv): ?>
                    <tr>
                        <td>#<?= $inv['invoice_id'] ?></td>
                        <td><?= htmlspecialchars($inv['customer_name'] ?? '-') ?></td>
                        <td><?= $inv['quantity'] ?></td>
                        <td><?= number_format($inv['price'],2) ?> ₺</td>
                        <td><?= $inv['date'] ?></td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php else: ?>
            <div class="alert alert-info">لا توجد فواتير مرتبطة بهذه المادة حتى الآن.</div>
        <?php endif; ?>
    </div>
    </body>
    </html>
    <?php
    exit;
}

// ======================= جلب كل المواد =======================
$products = $pdo->query("SELECT * FROM products ORDER BY id DESC")->fetchAll(PDO::FETCH_ASSOC);
?>

<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>📦 إدارة المواد</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { direction: rtl; background: #f6f6f9; }
.card { border-radius: 1rem; padding: 20px; box-shadow: 0 2px 8px rgba(0,0,0,0.1); }
.table thead th { background-color: #212529; color: #fff; }
.btn-sm { padding: 3px 8px; }
</style>
</head>
<body>

<?php include 'includes/navbar.php'; ?>

<div class="container py-4">
    <div class="card">
        <h3 class="mb-4 text-center">📦 إدارة المواد</h3>

        <!-- إضافة مادة -->
        <form method="POST" class="row g-2 mb-3">
            <div class="col-md"><input type="text" name="name" placeholder="اسم المادة" class="form-control" required></div>
            <div class="col-md"><input type="number" name="stock" placeholder="الكمية" class="form-control" required></div>
            <div class="col-md"><button class="btn btn-primary w-100" name="add">➕ إضافة</button></div>
        </form>

        <!-- رفع Excel -->
        <form method="POST" enctype="multipart/form-data" class="d-flex gap-2 mb-3">
            <input type="file" name="excel" accept=".xlsx,.xls" class="form-control" required>
            <button class="btn btn-success" name="upload">⬆️ رفع Excel</button>
        </form>

        <!-- تصدير Excel -->
        <form method="POST" class="mb-4">
            <button class="btn btn-warning w-100" name="export">⬇️ تصدير Excel</button>
        </form>

        <!-- جدول المواد -->
        <div class="table-responsive">
        <table class="table table-bordered table-striped align-middle text-center bg-white">
            <thead>
                <tr>
                    <th>رقم</th>
                    <th>الاسم</th>
                    <th>الوحدة</th>
                    <th>المخزون</th>
                    <th>تعديل المخزون</th>
                    <th>فواتير المادة</th>
                </tr>
            </thead>
            <tbody>
            <?php foreach($products as $p): ?>
                <tr>
                    <td><?= $p['id'] ?></td>
                    <td><?= htmlspecialchars($p['name'] ?? '-') ?></td>
                    <td>KG</td>
                    <td><?= $p['stock'] ?? 0 ?></td>
                    <td>
                        <form method="POST" class="d-flex justify-content-center align-items-center gap-1">
                            <input type="hidden" name="id" value="<?= $p['id'] ?>">
                            <input type="number" name="amount" min="1" value="1" class="form-control form-control-sm w-25" required>
                            <button type="submit" name="update_stock" class="btn btn-success btn-sm" onclick="this.form.action='?action=increase'; this.form.action.value='increase';">➕</button>
                            <button type="submit" name="update_stock" class="btn btn-danger btn-sm" onclick="this.form.action='?action=decrease'; this.form.action.value='decrease';">➖</button>
                            <input type="hidden" name="action" value="">
                        </form>
                    </td>
                    <td>
                        <a href="products.php?view_invoices=<?= $p['id'] ?>" class="btn btn-info btn-sm">📄 عرض الفواتير</a>
                    </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
        </div>

        <p class="text-muted small mt-3">
            📘 شكل ملف Excel المطلوب:  
            <br> العمود 1 = الاسم ، العمود 2 = الكمية  
            <br> مثال:  
            <br> <code>سكر | 20</code>  
            <br> <code>رز | 15</code>
        </p>
    </div>
</div>

</body>
</html>
