<?php
include 'includes/functions.php';
require_once __DIR__ . '/generate_invoice_pdf.php';

// التأكد من وجود رقم الفاتورة
$invoice_id = $_GET['invoice_id'] ?? null;
if (!$invoice_id) {
    die("رقم الفاتورة غير محدد");
}

// جلب بيانات الفاتورة
$stmt = $pdo->prepare("SELECT * FROM invoices WHERE id=?");
$stmt->execute([$invoice_id]);
$invoice = $stmt->fetch();
if (!$invoice) die("الفاتورة غير موجودة");

// جلب بيانات الشركة
$stmt = $pdo->prepare("SELECT * FROM companies WHERE id=?");
$stmt->execute([$invoice['company_id']]);
$company = $stmt->fetch();

// جلب عناصر الفاتورة
$stmt = $pdo->prepare("SELECT invoice_items.*, products.name, products.stock AS original_stock 
                       FROM invoice_items 
                       JOIN products ON invoice_items.product_id = products.id
                       WHERE invoice_id=?");
$stmt->execute([$invoice_id]);
$items = $stmt->fetchAll();

// تحديث الفاتورة عند الإرسال
if ($_SERVER['REQUEST_METHOD'] === 'POST') {

    $company_id = $_POST['company'] ?? $invoice['company_id'];
    $prices = $_POST['prices'] ?? [];
    $quantities = $_POST['quantities'] ?? [];
    $currency = $_POST['currency'] ?? $invoice['currency'];

    $total = 0;

    // تحديث المخزون: إعادة المخزون الأصلي أولاً
    foreach ($items as $i) {
        $pdo->prepare("UPDATE products SET stock = stock + ? WHERE id=?")
            ->execute([$i['quantity'], $i['product_id']]);
    }

    // تحديث عناصر الفاتورة
    foreach ($items as $i => $item) {
        $price = $prices[$i];
        $qty = $quantities[$i];

        // التحقق من المخزون الحالي
        $stmtStock = $pdo->prepare("SELECT stock FROM products WHERE id=?");
        $stmtStock->execute([$item['product_id']]);
        $product = $stmtStock->fetch();

        if ($qty > $product['stock']) {
            echo "<div class='alert alert-danger'>الكمية للمنتج {$item['name']} أكبر من المخزون ({$product['stock']})</div>";
            continue;
        }

        $total += $price * $qty;

        // تحديث قاعدة بيانات الفاتورة
        $pdo->prepare("UPDATE invoice_items SET quantity=?, price=? WHERE id=?")
            ->execute([$qty, $price, $item['id']]);

        // خصم المخزون الجديد
        $pdo->prepare("UPDATE products SET stock = stock - ? WHERE id=?")
            ->execute([$qty, $item['product_id']]);
    }

    // تحديث الفاتورة
    $pdo->prepare("UPDATE invoices SET company_id=?, total=?, currency=? WHERE id=?")
        ->execute([$company_id, $total, $currency, $invoice_id]);

    // إعادة جلب بيانات الشركة بعد التغيير
    $stmt = $pdo->prepare("SELECT * FROM companies WHERE id=?");
    $stmt->execute([$company_id]);
    $company = $stmt->fetch();

    // إنشاء PDF جديد
    $invoice_items = [];
    foreach ($items as $i => $item) {
        $invoice_items[] = [
            'name' => $item['name'],
            'quantity' => $quantities[$i],
            'price' => $prices[$i]
        ];
    }

    $file = generateInvoicePDF($invoice_id, $company, $invoice_items, $total, $currency);
    $pdf_web_path = 'invoices/invoice_'.$invoice_id.'.pdf';
    echo "<div class='alert alert-success'>تم تحديث الفاتورة بنجاح: <a href='$pdf_web_path' target='_blank'>عرض PDF</a></div>";
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تعديل الفاتورة</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
.invoice-item { display: flex; gap: 10px; margin-bottom: 12px; align-items: center; }
.invoice-item select, .invoice-item input { border-radius: 6px; }
.remove-btn { height: 38px; }
#items-container { margin-bottom: 20px; }
.card-form { background: #fff; padding: 25px; border-radius: 12px; box-shadow: 0 5px 15px rgba(0,0,0,0.05); }
.add-btn { margin-bottom: 20px; }
</style>
</head>
<body>
<?php include 'includes/navbar.php'; ?>

<div class="container py-5">
    <div class="card-form">
        <h3 class="text-center">✏️ تعديل الفاتورة #<?= $invoice_id ?></h3>
        <form method="POST">
            <!-- اختيار الشركة -->
            <div class="mb-4">
                <label class="form-label">الشركة</label>
                <select name="company" class="form-select" required>
                    <?php foreach($pdo->query("SELECT * FROM companies") as $c): ?>
                        <option value="<?= $c['id'] ?>" <?= $c['id']==$company['id']?'selected':'' ?>><?= $c['alici_adi'] ?></option>
                    <?php endforeach; ?>
                </select>
            </div>

            <!-- المنتجات -->
            <div id="items-container">
                <?php foreach($items as $i=>$item): ?>
                <div class="invoice-item">
                    <input type="text" class="form-control" value="<?= $item['name'] ?>" disabled style="flex:3;">
                    <input type="number" name="quantities[]" placeholder="الكمية" class="form-control" required style="flex:1;" value="<?= $item['quantity'] ?>">
                    <input type="number" name="prices[]" placeholder="السعر" class="form-control" required style="flex:1;" value="<?= $item['price'] ?>">
                </div>
                <?php endforeach; ?>
            </div>

            <!-- العملة -->
            <div class="mb-4">
                <label class="form-label">العملة</label>
                <select name="currency" class="form-select" required>
                    <option value="TL" <?= $invoice['currency']=='TL'?'selected':'' ?>>ليرة تركية (TL)</option>
                    <option value="USD" <?= $invoice['currency']=='USD'?'selected':'' ?>>دولار ($)</option>
                </select>
            </div>

            <button type="submit" class="btn btn-primary w-100">حفظ التعديلات</button>
        </form>
    </div>
</div>
</body>
</html>
