<?php
include 'includes/functions.php';

// إضافة شركة يدويًا
if(isset($_POST['add_company'])){
    $stmt = $pdo->prepare("INSERT INTO companies (alici_adi, alici_adresi, teslim_sekli, vergi_dairesi, vergi_numarasi) VALUES (?,?,?,?,?)");
    $stmt->execute([
        $_POST['alici_adi'], 
        $_POST['alici_adresi'], 
        $_POST['teslim_sekli'], 
        $_POST['vergi_dairesi'], 
        $_POST['vergi_numarasi']
    ]);
    $msg = "تم إضافة الشركة بنجاح!";
}

// رفع CSV
if(isset($_POST['upload_csv']) && isset($_FILES['csv_file'])){
    $file = $_FILES['csv_file']['tmp_name'];
    if(($handle = fopen($file, 'r')) !== FALSE){
        $header = fgetcsv($handle);
        while(($data = fgetcsv($handle)) !== FALSE){
            if(count($data) < 5) continue;
            $stmt = $pdo->prepare("SELECT id FROM companies WHERE alici_adi=? AND alici_adresi=?");
            $stmt->execute([$data[0], $data[1]]);
            $existing = $stmt->fetch();
            if($existing){
                $stmt = $pdo->prepare("UPDATE companies SET teslim_sekli=?, vergi_dairesi=?, vergi_numarasi=? WHERE id=?");
                $stmt->execute([$data[2], $data[3], $data[4], $existing['id']]);
            } else {
                $stmt = $pdo->prepare("INSERT INTO companies (alici_adi, alici_adresi, teslim_sekli, vergi_dairesi, vergi_numarasi) VALUES (?,?,?,?,?)");
                $stmt->execute([$data[0], $data[1], $data[2], $data[3], $data[4]]);
            }
        }
        fclose($handle);
        $msg = "تم معالجة الملف بنجاح!";
    }
}

// تصدير CSV
if(isset($_GET['export'])){
    header('Content-Type: text/csv; charset=UTF-8');
    header('Content-Disposition: attachment; filename=companies.csv');
    $output = fopen('php://output', 'w');
    fprintf($output, chr(0xEF).chr(0xBB).chr(0xBF));
    fputcsv($output, ['ALICI ADI','ALICI ADRESI','TESLIM ŞEKLİ','VERGİ DAİRESİ','VERGİ NUMARASI']);
    $companies = $pdo->query("SELECT * FROM companies")->fetchAll();
    foreach($companies as $c){
        fputcsv($output, [$c['alici_adi'],$c['alici_adresi'],$c['teslim_sekli'],$c['vergi_dairesi'],$c['vergi_numarasi']]);
    }
    fclose($output);
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar">
<head>
<meta charset="UTF-8">
<title>إدارة الشركات</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
@import url('https://fonts.googleapis.com/css2?family=Cairo:wght@400;600;700&display=swap');

body { font-family: 'Cairo', sans-serif; background: #f8f9fa; }
h3 { font-weight: 700; margin-bottom: 20px; text-align: center; }
.container { max-width: 1200px; }
.section { background: #fff; padding: 20px; margin-bottom: 30px; border-radius: 10px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
form input, form button, textarea { border-radius: 8px; }
form button { transition: all 0.3s ease; }
form button:hover { transform: translateY(-2px); }
#resultText { resize: none; }
.column-labels { margin-top: 10px; font-weight: 600; color: #555; }
</style>
</head>
<body>
<?php include 'includes/navbar.php'; ?>

<div class="container mt-4">
    <h3>إدارة الشركات</h3>
    <?php if(isset($msg)) echo "<div class='alert alert-success'>$msg</div>"; ?>

    <!-- قسم 1: رفع CSV -->
    <div class="section">
        <h5>رفع ملف CSV للشركات</h5>
        <form method="POST" enctype="multipart/form-data" class="d-flex gap-2 flex-wrap mb-2">
            <input type="file" name="csv_file" class="form-control flex-grow-1" accept=".csv" required>
            <button type="submit" name="upload_csv" class="btn btn-success">رفع CSV</button>
        </form>
        <div class="column-labels">
            ALICI ADI, ALICI ADRESI, TESLIM ŞEKLİ, VERGİ DAİRESİ, VERGİ NUMARASI
        </div>
    </div>

    <!-- قسم 2: تصدير CSV -->
    <div class="section">
        <h5>تصدير الشركات</h5>
        <a href="?export=1" class="btn btn-primary">تصدير CSV</a>
    </div>

    <!-- قسم 3: إضافة شركة يدويًا -->
    <div class="section">
        <h5>إضافة شركة يدويًا</h5>
        <form method="POST" class="row g-3">
            <div class="col-md"><input type="text" name="alici_adi" placeholder="ALICI ADI" class="form-control" required></div>
            <div class="col-md"><input type="text" name="alici_adresi" placeholder="ALICI ADRESI" class="form-control" required></div>
            <div class="col-md"><input type="text" name="teslim_sekli" placeholder="TESLIM ŞEKLİ" value="İŞ YERİNDE TESLİM" class="form-control"></div>
            <div class="col-md"><input type="text" name="vergi_dairesi" placeholder="VERGİ DAİRESİ" class="form-control"></div>
            <div class="col-md"><input type="text" name="vergi_numarasi" placeholder="VERGİ NUMARASI" class="form-control"></div>
            <div class="col-md-auto"><button type="submit" name="add_company" class="btn btn-primary w-100">إضافة الشركة</button></div>
        </form>
    </div>

    <!-- قسم 4: رفع صورة وتحويلها إلى نص تركي -->
    <div class="section">
        <h5>رفع صورة وتحويلها إلى نص (بالتركي)</h5>
        <div class="row justify-content-center mt-3">
            <div class="col-md-6">
                <input type="file" id="imageInput" accept="image/*" class="form-control mb-2">
                <button id="convertBtn" class="btn btn-success w-100">تحويل الصورة</button>
            </div>
        </div>
        <div class="row mt-3">
            <div class="col-md-8 mx-auto">
                <textarea id="resultText" class="form-control" rows="8" placeholder="سيظهر النص المستخرج هنا..."></textarea>
            </div>
        </div>
    </div>

</div>

<script src="https://cdn.jsdelivr.net/npm/tesseract.js@4.1.1/dist/tesseract.min.js"></script>
<script>
document.getElementById('convertBtn').addEventListener('click', () => {
    const input = document.getElementById('imageInput');
    const result = document.getElementById('resultText');

    if(input.files.length === 0){
        alert('الرجاء اختيار صورة أولاً.');
        return;
    }

    const file = input.files[0];
    result.value = 'جارٍ التحويل... يرجى الانتظار';

    Tesseract.recognize(
        file,
        'tur', // استخراج النص بالتركي
        { logger: m => console.log(m) }
    ).then(({ data: { text } }) => {
        result.value = text;
    }).catch(err => {
        result.value = 'حدث خطأ أثناء التحويل.';
        console.error(err);
    });
});
</script>

</body>
</html>
