<?php
require 'includes/functions.php'; // تأكد أن هذا الملف يحتوي على $pdo

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['invoice_id'])) {
    $invoice_id = (int) $_POST['invoice_id'];

    // ✅ 1. جلب المواد المرتبطة بالفاتورة
    $stmtItems = $pdo->prepare("SELECT product_id, quantity FROM invoice_items WHERE invoice_id = ?");
    $stmtItems->execute([$invoice_id]);
    $items = $stmtItems->fetchAll();

    // ✅ 2. إعادة الكميات إلى المخزون
    foreach ($items as $item) {
        $stmtUpdate = $pdo->prepare("UPDATE products SET stock = stock + ? WHERE id = ?");
        $stmtUpdate->execute([$item['quantity'], $item['product_id']]);
    }

    // ✅ 3. حذف المواد المرتبطة بالفاتورة
    $stmt = $pdo->prepare("DELETE FROM invoice_items WHERE invoice_id = ?");
    $stmt->execute([$invoice_id]);

    // ✅ 4. حذف الفاتورة نفسها
    $stmt = $pdo->prepare("DELETE FROM invoices WHERE id = ?");
    $stmt->execute([$invoice_id]);

    // ✅ 5. حذف ملف PDF إن وجد
    $file = "invoices/invoice_" . $invoice_id . ".pdf";
    if (file_exists($file)) {
        unlink($file);
    }

    // ✅ 6. إعادة التوجيه بعد الحذف
    header("Location: invoices.php?deleted=1");
    exit;

} else {
    header("Location: invoices.php");
    exit;
}
