<?php
session_start();
require 'config.php';
if (empty($_SESSION['user'])) {
    header('Location: login.php');
    exit;
}

// --- إحصائيات سريعة ---
$total_products = $pdo->query("SELECT COUNT(*) FROM products")->fetchColumn();
$total_stock_weight = $pdo->query("SELECT IFNULL(SUM(total_weight),0) FROM stock")->fetchColumn();
$total_sales = $pdo->query("SELECT IFNULL(SUM(price),0) FROM sales")->fetchColumn();
$total_movements = $pdo->query("SELECT COUNT(*) FROM stock_movements")->fetchColumn();
$recent_sales = $pdo->query("SELECT s.*, p.name FROM sales s JOIN products p ON p.id = s.product_id ORDER BY s.sale_date DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
$recent_movements = $pdo->query("SELECT m.*, p.name FROM stock_movements m JOIN products p ON p.id = m.product_id ORDER BY m.date_added DESC LIMIT 5")->fetchAll(PDO::FETCH_ASSOC);
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="utf-8">
<title>📦 لوحة التحكم - نظام إدارة المخزون</title>
<meta name="viewport" content="width=device-width, initial-scale=1">
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.jsdelivr.net/npm/bootstrap-icons@1.10.5/font/bootstrap-icons.css" rel="stylesheet">
<style>
body { background-color: #f4f6f8; font-family: 'Tajawal', sans-serif; }
.card { border-radius: 18px; }
.stat-card {
    transition: all 0.3s ease;
}
.stat-card:hover {
    transform: translateY(-4px);
    box-shadow: 0 6px 16px rgba(0,0,0,0.1);
}
.table thead th { background-color: #e9ecef; }
</style>
</head>
<body>

<?php include 'navbar.php'; ?>

<div class="container py-4">
  <h3 class="mb-4 text-center">📊 لوحة التحكم الرئيسية</h3>

  <!-- البطاقات الإحصائية -->
  <div class="row g-3 mb-4">
    <div class="col-md-3">
      <div class="card stat-card text-center shadow-sm bg-primary text-white">
        <div class="card-body">
          <i class="bi bi-box-seam fs-1 mb-2"></i>
          <h5>عدد المواد</h5>
          <h3><?= $total_products ?></h3>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card stat-card text-center shadow-sm bg-success text-white">
        <div class="card-body">
          <i class="bi bi-stack fs-1 mb-2"></i>
          <h5>إجمالي المخزون (كغ)</h5>
          <h3><?= number_format($total_stock_weight, 2) ?></h3>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card stat-card text-center shadow-sm bg-warning text-dark">
        <div class="card-body">
          <i class="bi bi-cash-coin fs-1 mb-2"></i>
          <h5>إجمالي المبيعات</h5>
          <h3><?= number_format($total_sales, 2) ?> ₺</h3>
        </div>
      </div>
    </div>
    <div class="col-md-3">
      <div class="card stat-card text-center shadow-sm bg-info text-dark">
        <div class="card-body">
          <i class="bi bi-arrow-repeat fs-1 mb-2"></i>
          <h5>عدد الحركات</h5>
          <h3><?= $total_movements ?></h3>
        </div>
      </div>
    </div>
  </div>

  <!-- روابط سريعة -->
  <div class="d-grid gap-3 col-12 col-lg-8 mx-auto mb-5">
    <a href="products.php" class="btn btn-outline-success btn-lg"><i class="bi bi-bricks"></i> تسجيل المواد</a>
    <a href="stock.php" class="btn btn-outline-primary btn-lg"><i class="bi bi-box2-fill"></i> إضافة مخزون</a>
    <a href="sales.php" class="btn btn-outline-warning btn-lg"><i class="bi bi-cart-check-fill"></i> تسجيل المبيعات</a>
    <a href="reports.php" class="btn btn-outline-info btn-lg"><i class="bi bi-bar-chart-fill"></i> التقارير</a>
  </div>

  <!-- آخر المبيعات وحركات المخزون -->
  <div class="row g-4">
    <div class="col-md-6">
      <div class="card shadow-sm">
        <div class="card-header bg-warning text-dark fw-bold">
          💰 آخر المبيعات
        </div>
        <div class="table-responsive">
          <table class="table table-sm table-hover mb-0">
            <thead>
              <tr class="text-center"><th>المادة</th><th>الكمية</th><th>السعر</th><th>التاريخ</th></tr>
            </thead>
            <tbody>
              <?php foreach($recent_sales as $s): ?>
              <tr class="text-center">
                <td><?= htmlspecialchars($s['name']) ?></td>
                <td><?= $s['bags_sold'] ?> شوال</td>
                <td><?= number_format($s['price'], 2) ?> ₺</td>
                <td><?= $s['sale_date'] ?></td>
              </tr>
              <?php endforeach; ?>
              <?php if(!$recent_sales): ?><tr><td colspan="4" class="text-center text-muted">لا توجد بيانات</td></tr><?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>

    <div class="col-md-6">
      <div class="card shadow-sm">
        <div class="card-header bg-info fw-bold">
          📦 آخر حركات المخزون
        </div>
        <div class="table-responsive">
          <table class="table table-sm table-hover mb-0">
            <thead>
              <tr class="text-center"><th>المادة</th><th>عدد الشوالات</th><th>النوع</th><th>التاريخ</th></tr>
            </thead>
            <tbody>
              <?php foreach($recent_movements as $m): ?>
              <tr class="text-center">
                <td><?= htmlspecialchars($m['name']) ?></td>
                <td><?= $m['bags_count'] ?></td>
                <td><?= $m['movement_type'] === 'addition' ? 'إضافة' : 'خصم' ?></td>
                <td><?= $m['date_added'] ?></td>
              </tr>
              <?php endforeach; ?>
              <?php if(!$recent_movements): ?><tr><td colspan="4" class="text-center text-muted">لا توجد بيانات</td></tr><?php endif; ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
