<?php
require 'vendor/autoload.php';
use Smalot\PdfParser\Parser;
session_start();

// ---------- إعداد قاعدة البيانات ----------
$db_host = "localhost";
$db_user = "deltaaccounting_aljameelsys";    
$db_pass = "deltaaccounting_aljameelsys";    
$db_name = "LWUxk[^lpqNRC-;~";    

$conn = new mysqli($db_host, $db_user, $db_pass, $db_name);
if ($conn->connect_error) die("فشل الاتصال: " . $conn->connect_error);
$conn->set_charset("utf8mb4");

// ---------- دالة ذكية لاستخراج الحقول ----------
function extractField($text, $field, $removeExtra = []) {
    $cleanText = preg_replace('/\s+/u', ' ', $text);

    $nextFields = [
        'ALICI ADI', 'ALICI ADRESI',
        'TESLIM ŞEKLİ', 'TESLIM ŞEKLI',
        'VERGİ DAİRESİ', 'VERGI DAİRESİ', 'VERGI DAIRESI', 'VERGI DIARASI',
        'VERGI NUMARASI', 'URUN AÇIKLAMASI', 'MIKTAR', 'BIRIM', 'BIRIM FIYAT', 'GENEL TUTAR'
    ];

    $nextPattern = implode('|', array_map('preg_quote', $nextFields));
    $pattern = '/'.preg_quote($field, '/').'\s*:?([\s\S]*?)(?='.$nextPattern.':|$)/iu';

    if (preg_match($pattern, $cleanText, $m)) {
        $value = trim($m[1]);
        foreach ($removeExtra as $u) $value = str_ireplace($u, '', $value);
        $value = preg_replace('/\s{2,}/u', ' ', $value);
        return trim($value);
    }
    return '';
}

// ---------- إدخال البيانات إلى قاعدة البيانات ----------
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action']) && $_POST['action'] === 'import') {
    $rows = $_POST['rows'] ?? [];
    $inserted = 0;

    $stmt = $conn->prepare("INSERT INTO companies (alici_adi, alici_adresi, teslim_sekli, vergi_dairesi, vergi_numarasi) VALUES (?, ?, ?, ?, ?)");

    foreach ($rows as $r) {
        $stmt->bind_param("sssss",
            $r['alici_adi'],
            $r['alici_adresi'],
            $r['teslim_sekli'],
            $r['vergi_dairesi'],
            $r['vergi_numarasi']
        );
        if ($stmt->execute()) $inserted++;
    }
    $stmt->close();

    echo "<h3>✅ تمت إضافة $inserted سجل(سجلات) إلى قاعدة البيانات.</h3>";
    echo "<p><a href=\"{$_SERVER['PHP_SELF']}\">عودة لرفع ملفات جديدة</a></p>";
    exit;
}

// ---------- رفع ملفات PDF ومعاينتها ----------
$previewRows = [];
if ($_SERVER['REQUEST_METHOD'] === 'POST' && !empty($_FILES['pdfs'])) {
    $uploadDir = __DIR__ . '/uploads';
    if (!is_dir($uploadDir)) mkdir($uploadDir, 0777, true);

    $parser = new Parser();
    $unwanted = ['YURTIÇI FATURASI', 'DOMESTIC INVOICE', 'ة فاتورة داخل'];

    foreach ($_FILES['pdfs']['tmp_name'] as $i => $tmpPath) {
        $origName = basename($_FILES['pdfs']['name'][$i]);
        $target = $uploadDir . '/' . $origName;
        if (!move_uploaded_file($tmpPath, $target)) continue;

        try {
            $pdf = $parser->parseFile($target);
            $text = $pdf->getText();

            // تنظيف النص الكامل
            $cleanText = mb_convert_encoding($text, 'UTF-8', 'auto');
            $cleanText = str_replace(["\r\n", "\r"], "\n", $cleanText);
            $cleanText = preg_replace('/\s{2,}/u', ' ', $cleanText);

            $row = [
                'file' => $origName,
                'full_text' => $cleanText, // النص الكامل بعد التنظيف
                'alici_adi' => extractField($text, 'ALICI ADI', $unwanted),
                'alici_adresi' => extractField($text, 'ALICI ADRESI', $unwanted),
                'teslim_sekli' => extractField($text, 'TESLIM ŞEKLİ', $unwanted),
                'vergi_dairesi' => (
                    extractField($text, 'VERGİ DAİRESİ', $unwanted)
                    ?: extractField($text, 'VERGI DAİRESİ', $unwanted)
                    ?: extractField($text, 'VERGI DAIRESI', $unwanted)
                    ?: extractField($text, 'VERGI DIARASI', $unwanted)
                ),
                'vergi_numarasi' => extractField($text, 'VERGI NUMARASI', $unwanted)
            ];
            $previewRows[] = $row;

        } catch (Exception $e) {
            $previewRows[] = ['file' => $origName, 'error' => $e->getMessage()];
        }
    }

    $_SESSION['preview_rows'] = $previewRows;
}
?>
<!doctype html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>رفع PDF — استخراج وتعديل قبل الحفظ</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{font-family:'Cairo',sans-serif;background:#f5f7fb;padding:20px}
.card{margin:10px auto;max-width:1100px;}
input[type=text]{width:100%;padding:4px;}
textarea{width:100%;padding:6px;resize:vertical;white-space:pre-wrap;}
.file-title{background:#eef2ff;padding:6px 10px;border-radius:6px;margin-bottom:8px;font-weight:bold}
fieldset{border:1px solid #ccc;border-radius:10px;padding:10px;margin-bottom:15px;}
legend{font-size:14px;font-weight:bold;}
</style>
</head>
<body>
<div class="card">
<div class="card-body">
<h4>📄 رفع ملفات PDF — استخراج تلقائي + تعديل يدوي</h4>

<form method="post" enctype="multipart/form-data" class="mb-3">
<input type="file" name="pdfs[]" multiple accept="application/pdf" class="form-control mb-2" required>
<button class="btn btn-primary">رفع و معالجة</button>
</form>

<?php if(!empty($_SESSION['preview_rows'])): 
$rows = $_SESSION['preview_rows']; ?>
<form method="post">
<input type="hidden" name="action" value="import">
<?php foreach($rows as $index=>$r): ?>
<fieldset>
<legend>📄 <?php echo htmlspecialchars($r['file']); ?></legend>

<!-- عرض النص الكامل -->
<?php if(isset($r['full_text'])): ?>
<div class="mb-2">
<label>النص الكامل المستخرج:</label>
<textarea class="form-control" rows="8" readonly><?php echo htmlspecialchars($r['full_text']); ?></textarea>
</div>
<?php endif; ?>

<div class="row mb-2">
<div class="col-md-6">
<label>ALICI ADI:</label>
<input type="text" name="rows[<?php echo $index; ?>][alici_adi]" value="<?php echo htmlspecialchars($r['alici_adi'] ?? ''); ?>">
</div>
<div class="col-md-6">
<label>ALICI ADRESI:</label>
<input type="text" name="rows[<?php echo $index; ?>][alici_adresi]" value="<?php echo htmlspecialchars($r['alici_adresi'] ?? ''); ?>">
</div>
</div>
<div class="row mb-2">
<div class="col-md-4">
<label>TESLIM ŞEKLİ:</label>
<input type="text" name="rows[<?php echo $index; ?>][teslim_sekli]" value="<?php echo htmlspecialchars($r['teslim_sekli'] ?? ''); ?>">
</div>
<div class="col-md-4">
<label>VERGİ DAİRESİ:</label>
<input type="text" name="rows[<?php echo $index; ?>][vergi_dairesi]" value="<?php echo htmlspecialchars($r['vergi_dairesi'] ?? ''); ?>">
</div>
<div class="col-md-4">
<label>VERGİ NUMARASI:</label>
<input type="text" name="rows[<?php echo $index; ?>][vergi_numarasi]" value="<?php echo htmlspecialchars($r['vergi_numarasi'] ?? ''); ?>">
</div>
</div>
</fieldset>
<?php endforeach; ?>
<button type="submit" class="btn btn-success">💾 استيراد المحدد إلى قاعدة البيانات</button>
<a href="<?php echo $_SERVER['PHP_SELF']; ?>" class="btn btn-secondary">🔄 مسح وإعادة رفع</a>
</form>
<?php else: ?>
<div class="alert alert-info">قم برفع ملفات PDF لعرض البيانات المستخرجة وتعديلها قبل الحفظ.</div>
<?php endif; ?>
</div>
</div>
</body>
</html>
