<?php
include 'includes/functions.php';

// فلاتر البحث
$filter_company = $_GET['company'] ?? '';
$filter_username = $_GET['username'] ?? '';
$filter_product = $_GET['product'] ?? '';
$filter_currency = $_GET['currency'] ?? '';
$filter_date_from = $_GET['date_from'] ?? '';
$filter_date_to = $_GET['date_to'] ?? '';

// الشرط الأساسي: الفواتير المقبولة فقط
$where = ["i.status = 'approved'"];
$params = [];

// إضافة فلاتر إضافية إذا تم اختيارها
if($filter_company){ $where[] = "i.company_id = ?"; $params[] = $filter_company; }
if($filter_username){ $where[] = "(c.username LIKE ? OR c.alici_adi LIKE ?)"; $params[] = "%$filter_username%"; $params[] = "%$filter_username%"; }
if($filter_currency){ $where[] = "i.currency = ?"; $params[] = $filter_currency; }
if($filter_date_from){ $where[] = "i.created_at >= ?"; $params[] = $filter_date_from.' 00:00:00'; }
if($filter_date_to){ $where[] = "i.created_at <= ?"; $params[] = $filter_date_to.' 23:59:59'; }
if($filter_product){ $where[] = "p.id = ?"; $params[] = $filter_product; }

$where_sql = "WHERE ".implode(" AND ", $where);

// الاستعلام الرئيسي
$sql = "
SELECT 
    i.id AS invoice_id,
    i.created_at,
    i.currency,
    c.alici_adi AS company_name,
    c.username AS company_user,
    p.name AS product_name,
    ii.quantity,
    ii.price AS sale_price,
    ii.cost_per_unit AS purchase_price,
    (ii.price - ii.cost_per_unit) AS profit_per_unit,
    (ii.quantity * (ii.price - ii.cost_per_unit)) AS total_profit,
    (ii.quantity * ii.price) AS total_sales
FROM invoice_items ii
JOIN invoices i ON ii.invoice_id = i.id
JOIN products p ON ii.product_id = p.id
LEFT JOIN companies c ON i.company_id = c.id
$where_sql
ORDER BY i.created_at DESC
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$rows = $stmt->fetchAll();

// بيانات الفلاتر
$companies = $pdo->query("SELECT * FROM companies ORDER BY alici_adi ASC")->fetchAll();
$products = $pdo->query("SELECT * FROM products ORDER BY name ASC")->fetchAll();
$currencies = ['TL'=>'ليرة تركية','USD'=>'دولار'];

// الحسابات النهائية
$total_profit = array_sum(array_column($rows,'total_profit'));
$total_sales = array_sum(array_column($rows,'total_sales'));
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>📊 تقرير المبيعات والأرباح للفواتير المقبولة</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<link href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap5.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap5.min.js"></script>

<style>
body { background-color:#f8f9fa; font-family:'Cairo', sans-serif; }
h3 { margin-bottom:25px; color:#0d6efd; }
.table thead { background:#0d6efd; color:white; text-align:center; }
tfoot { font-weight:bold; background:#f1f3f5; }
.card-filter { background:white; border-radius:12px; padding:20px; margin-bottom:20px; box-shadow:0 2px 10px rgba(0,0,0,0.05); }
</style>
</head>
<body>

<?php include 'includes/navbar.php'; ?>

<div class="container py-4">
    <h3>📈 تقرير المبيعات والأرباح للفواتير المقبولة</h3>

    <!-- الفلاتر -->
    <form method="GET" class="row g-3 card-filter">
        <div class="col-md-3">
            <label>الشركة</label>
            <select name="company" class="form-select">
                <option value="">الكل</option>
                <?php foreach($companies as $c): ?>
                <option value="<?= $c['id'] ?>" <?= $filter_company==$c['id']?'selected':'' ?>>
                    <?= htmlspecialchars($c['alici_adi']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <label>اسم المستخدم / الشركة</label>
            <input type="text" name="username" value="<?= htmlspecialchars($filter_username) ?>" class="form-control" placeholder="ابحث باليوزر أو الاسم...">
        </div>
        <div class="col-md-3">
            <label>المادة</label>
            <select name="product" class="form-select">
                <option value="">الكل</option>
                <?php foreach($products as $p): ?>
                <option value="<?= $p['id'] ?>" <?= $filter_product==$p['id']?'selected':'' ?>>
                    <?= htmlspecialchars($p['name']) ?>
                </option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <label>العملة</label>
            <select name="currency" class="form-select">
                <option value="">الكل</option>
                <?php foreach($currencies as $k=>$v): ?>
                <option value="<?= $k ?>" <?= $filter_currency==$k?'selected':'' ?>><?= $v ?></option>
                <?php endforeach; ?>
            </select>
        </div>
        <div class="col-md-3">
            <label>من تاريخ</label>
            <input type="date" name="date_from" value="<?= $filter_date_from ?>" class="form-control">
        </div>
        <div class="col-md-3">
            <label>إلى تاريخ</label>
            <input type="date" name="date_to" value="<?= $filter_date_to ?>" class="form-control">
        </div>
        <div class="col-md-12 mt-2">
            <button class="btn btn-primary">تطبيق الفلاتر</button>
            <a href="detailed_report.php" class="btn btn-secondary">مسح</a>
        </div>
    </form>

    <!-- الجدول -->
    <div class="card p-3 shadow-sm">
        <table id="reportTable" class="table table-striped table-bordered align-middle">
            <thead>
                <tr>
                    <th>رقم الفاتورة</th>
                    <th>التاريخ</th>
                    <th>الشركة</th>
                    <th>اليوزر</th>
                    <th>المادة</th>
                    <th>الكمية</th>
                    <th>سعر الشراء</th>
                    <th>سعر البيع</th>
                    <th>الفرق للوحدة</th>
                    <th>الربح الإجمالي</th>
                    <th>إجمالي المبيعات</th>
                    <th>العملة</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach($rows as $r): ?>
                <tr>
                    <td><?= $r['invoice_id'] ?></td>
                    <td><?= $r['created_at'] ?></td>
                    <td><?= htmlspecialchars($r['company_name']) ?></td>
                    <td><?= htmlspecialchars($r['company_user']) ?></td>
                    <td><?= htmlspecialchars($r['product_name']) ?></td>
                    <td><?= $r['quantity'] ?></td>
                    <td class="text-info"><?= number_format($r['purchase_price'],2) ?></td>
                    <td class="text-primary"><?= number_format($r['sale_price'],2) ?></td>
                    <td class="text-success"><?= number_format($r['profit_per_unit'],2) ?></td>
                    <td class="fw-bold text-success"><?= number_format($r['total_profit'],2) ?></td>
                    <td class="fw-bold text-primary"><?= number_format($r['total_sales'],2) ?></td>
                    <td><?= $r['currency'] ?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <tr>
                    <td colspan="9" class="text-end">💰 إجمالي الأرباح:</td>
                    <td class="text-success fw-bold"><?= number_format($total_profit,2) ?></td>
                    <td colspan="2"></td>
                </tr>
                <tr>
                    <td colspan="9" class="text-end">💵 إجمالي المبيعات:</td>
                    <td class="text-primary fw-bold"><?= number_format($total_sales,2) ?></td>
                    <td colspan="2"></td>
                </tr>
            </tfoot>
        </table>
    </div>
</div>

<script>
$(document).ready(function(){
    $('#reportTable').DataTable({
        "language": {"url": "//cdn.datatables.net/plug-ins/1.13.6/i18n/ar.json"},
        "order": [[1,"desc"]],
        "pageLength": 25
    });
});
</script>

</body>
</html>
