<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
session_start();
include 'includes/functions.php';
require_once __DIR__ . '/generate_invoice_pdf.php';

// -------------------- قبول الفاتورة --------------------
if (isset($_GET['approve'])) {
    $invoice_id = (int)$_GET['approve'];

    $stmt = $pdo->prepare("SELECT * FROM invoices WHERE id=? AND status='pending'");
    $stmt->execute([$invoice_id]);
    $invoice = $stmt->fetch();

    if ($invoice) {
        $stmtItems = $pdo->prepare("SELECT * FROM invoice_items WHERE invoice_id=?");
        $stmtItems->execute([$invoice_id]);
        $items = $stmtItems->fetchAll();

        $total_profit = 0;

        foreach ($items as $item) {
            $pid = $item['product_id'];
            $qty = $item['quantity'];
            $price = $item['price'];

            $cost_per_unit = reduceStockFIFO($pdo, $pid, $qty);
            if ($cost_per_unit === null) $cost_per_unit = 0;

            $pdo->prepare("UPDATE products SET stock = stock - ? WHERE id=?")->execute([$qty, $pid]);
            $pdo->prepare("UPDATE invoice_items SET cost_per_unit=? WHERE id=?")->execute([$cost_per_unit, $item['id']]);
            $total_profit += ($price - $cost_per_unit) * $qty;
        }

        $pdo->prepare("UPDATE invoices SET profit=?, status='approved' WHERE id=?")
            ->execute([$total_profit, $invoice_id]);

        echo "<div class='alert alert-success text-center'>
            ✅ تم قبول الفاتورة رقم $invoice_id بنجاح.<br>
            💰 الربح المحسوب: <b>{$total_profit} {$invoice['currency']}</b>
        </div>";
    } else {
        echo "<div class='alert alert-danger text-center'>⚠️ الفاتورة غير موجودة أو تم قبولها مسبقًا.</div>";
    }
}

// -------------------- حذف الفاتورة --------------------
if (isset($_GET['delete'])) {
    $invoice_id = (int)$_GET['delete'];
    $pdo->prepare("DELETE FROM invoice_items WHERE invoice_id=?")->execute([$invoice_id]);
    $pdo->prepare("DELETE FROM invoices WHERE id=?")->execute([$invoice_id]);
    echo "<div class='alert alert-danger text-center'>🗑️ تم حذف الفاتورة رقم $invoice_id</div>";
}

// -------------------- جلب الفواتير المعلقة فقط --------------------
$invoices = $pdo->query("
    SELECT i.*, c.alici_adi, c.username
    FROM invoices i 
    LEFT JOIN companies c ON i.company_id = c.id
    WHERE i.status='pending'
    ORDER BY i.id DESC
")->fetchAll();
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>🕒 الفواتير المعلقة</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body { background:#f8f9fa; font-family:'Cairo', sans-serif; }
.table { background:white; border-radius:10px; overflow:hidden; }
h3 { color:#0d6efd; margin-bottom:25px; }
.btn-approve { background-color:#28a745; color:white; border:none; padding:5px 12px; border-radius:6px; }
.btn-approve:hover { background-color:#218838; }
.btn-delete { background-color:#dc3545; color:white; border:none; padding:5px 12px; border-radius:6px; }
.btn-delete:hover { background-color:#c82333; }
.btn-edit { background-color:#ffc107; color:black; border:none; padding:5px 12px; border-radius:6px; }
.btn-edit:hover { background-color:#e0a800; color:white; }
.table td:last-child { text-align: left; }
</style>
</head>
<body>

<?php include 'includes/navbar.php'; ?>

<div class="container py-4">
    <h3 class="text-center">🕒 الفواتير المعلقة</h3>

    <div class="table-responsive">
        <?php if(empty($invoices)): ?>
            <div class="alert alert-info text-center">لا توجد فواتير معلقة حالياً.</div>
        <?php else: ?>
            <table class="table table-bordered text-center align-middle">
                <thead class="table-primary">
                    <tr>
                        <th>رقم الفاتورة</th>
                        <th>العميل</th>
                        <th>الإجمالي</th>
                        <th>العملة</th>
                        <th>تاريخ الإنشاء</th>
                        <th>الإجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach($invoices as $inv): ?>
                    <?php
                        $display_name = !empty($inv['username']) ? $inv['username'] : $inv['alici_adi'];
                    ?>
                    <tr>
                        <td><?= $inv['id'] ?></td>
                        <td><?= htmlspecialchars($display_name) ?></td>
                        <td><?= number_format($inv['total'],2) ?></td>
                        <td><?= htmlspecialchars($inv['currency']) ?></td>
                        <td><?= htmlspecialchars($inv['created_at']) ?></td>
                        <td>
                            <a href="invoices/invoice_<?= $inv['id'] ?>.pdf" target="_blank" class="btn btn-sm btn-secondary">📄 PDF</a>
                            <a href="edit_invoice.php?id=<?= $inv['id'] ?>" class="btn btn-edit btn-sm">✏️ تعديل</a>
                            <a href="?approve=<?= $inv['id'] ?>" class="btn btn-approve btn-sm" onclick="return confirm('هل أنت متأكد من قبول هذه الفاتورة؟')">✅ قبول</a>
                            <a href="?delete=<?= $inv['id'] ?>" class="btn btn-delete btn-sm" onclick="return confirm('هل أنت متأكد من حذف هذه الفاتورة؟')">🗑️ حذف</a>
                            <a href="https://wa.me/905342009438?text=رابط الفاتورة: <?= urlencode('https://deltaweb.agency/invoice-system/invoices/invoice_'.$inv['id'].'.pdf') ?>" target="_blank" class="btn btn-info btn-sm">📲 واتساب</a>
                        </td>
                    </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        <?php endif; ?>
    </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
