<?php
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

include 'includes/functions.php';

// --- فحص المخزون المنخفض ---
$stmt = $pdo->prepare("SELECT name, stock, unit FROM products WHERE stock < 1000 ORDER BY stock ASC");
$stmt->execute();
$low_stock_products = $stmt->fetchAll();

// بيانات المبيعات الشهرية
$months = [];
$monthly_totals = [];
for($m=1;$m<=12;$m++){
    $months[] = date('F', mktime(0,0,0,$m,1));
    $stmt = $pdo->prepare("SELECT SUM(total) as sum_total FROM invoices WHERE MONTH(created_at)=? AND YEAR(created_at)=?");
    $stmt->execute([$m, date('Y')]);
    $res = $stmt->fetch();
    $monthly_totals[] = $res['sum_total'] ?? 0;
}

// عدد الفواتير لكل شركة
$companies = $pdo->query("SELECT id, alici_adi FROM companies")->fetchAll();
$company_labels = [];
$company_counts = [];
foreach($companies as $c){
    $company_labels[] = $c['alici_adi'];
    $stmt = $pdo->prepare("SELECT COUNT(*) as cnt FROM invoices WHERE company_id=?");
    $stmt->execute([$c['id']]);
    $res = $stmt->fetch();
    $company_counts[] = $res['cnt'];
}

// المبيعات حسب العملة
$currencies = ['TL'=>'ليرة تركية','USD'=>'دولار'];
$currency_totals = [];
foreach($currencies as $k=>$v){
    $stmt = $pdo->prepare("SELECT SUM(total) as sum_total FROM invoices WHERE currency=?");
    $stmt->execute([$k]);
    $res = $stmt->fetch();
    $currency_totals[] = $res['sum_total'] ?? 0;
}

// أكثر المنتجات مبيعًا
$stmt = $pdo->query("SELECT products.name, SUM(invoice_items.quantity) as total_qty 
                     FROM invoice_items 
                     JOIN products ON products.id = invoice_items.product_id 
                     GROUP BY products.id ORDER BY total_qty DESC LIMIT 5");
$top_products = $stmt->fetchAll();
$product_labels = [];
$product_quantities = [];
foreach($top_products as $p){
    $product_labels[] = $p['name'];
    $product_quantities[] = $p['total_qty'];
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>التقارير - Dashboard</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<style>
body { background-color: #f8f9fa; font-family: 'Cairo', sans-serif; }
.card { border-radius: 12px; }
.card h5 { font-weight: bold; }
.card-dashboard { cursor: pointer; border-radius: 12px; transition: transform 0.2s, box-shadow 0.2s; }
.card-dashboard:hover { transform: translateY(-5px); box-shadow: 0 8px 20px rgba(0,0,0,0.15); }
.card-icon { font-size: 2.5rem; margin-bottom: 10px; }
.card-title { font-size: 1.2rem; font-weight: bold; }
</style>
</head>
<body>
<?php include 'includes/navbar.php'; ?>

<div class="container py-4">

<h2 class="mb-4 text-primary text-center">لوحة التحكم - التقارير</h2>

<!-- تنبيه المخزون المنخفض -->
<?php if(!empty($low_stock_products)): ?>
<div class="alert alert-danger">
    <strong>تحذير:</strong> المنتجات التالية مخزونها أقل من 1000:<br>
    <?php foreach($low_stock_products as $p): ?>
        - <?= htmlspecialchars($p['name']) ?> (<?= $p['stock'] ?> <?= htmlspecialchars($p['unit']) ?>)<br>
    <?php endforeach; ?>
</div>
<?php endif; ?>

<!-- مربعات الأقسام الرئيسية -->
<div class="row g-4 mb-5">
    <div class="col-md-4">
        <a href="companies_list.php" class="text-decoration-none text-dark">
            <div class="card card-dashboard text-center p-4 bg-primary text-white">
                <div class="card-icon">🏢</div>
                <div class="card-title">الشركات</div>
            </div>
        </a>
    </div>
    <div class="col-md-4">
        <a href="companies_manage.php" class="text-decoration-none text-dark">
            <div class="card card-dashboard text-center p-4 bg-warning text-dark">
                <div class="card-icon">⚙️</div>
                <div class="card-title">إدارة الشركات</div>
            </div>
        </a>
    </div>
    <div class="col-md-4">
        <a href="products.php" class="text-decoration-none text-dark">
            <div class="card card-dashboard text-center p-4 bg-success text-white">
                <div class="card-icon">📦</div>
                <div class="card-title">المواد</div>
            </div>
        </a>
    </div>
    <div class="col-md-6">
        <a href="create_invoice.php" class="text-decoration-none text-dark">
            <div class="card card-dashboard text-center p-4 bg-info text-white">
                <div class="card-icon">🧾</div>
                <div class="card-title">إنشاء فاتورة</div>
            </div>
        </a>
    </div>
    <div class="col-md-6">
        <a href="invoices.php" class="text-decoration-none text-dark">
            <div class="card card-dashboard text-center p-4 bg-danger text-white">
                <div class="card-icon">📋</div>
                <div class="card-title">الفواتير</div>
            </div>
        </a>
    </div>
</div>

<!-- الرسوم البيانية -->
<div class="row g-4">
    <div class="col-md-6">
        <div class="card p-3">
            <h5>إجمالي المبيعات لكل شهر (<?= date('Y') ?>)</h5>
            <canvas id="monthlySales"></canvas>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card p-3">
            <h5>عدد الفواتير لكل شركة</h5>
            <canvas id="companyInvoices"></canvas>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card p-3">
            <h5>إجمالي المبيعات حسب العملة</h5>
            <canvas id="currencySales"></canvas>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card p-3">
            <h5>أكثر 5 منتجات مبيعاً</h5>
            <canvas id="topProducts"></canvas>
        </div>
    </div>
</div>
</div>

<script>
new Chart(document.getElementById('monthlySales'), {
    type: 'bar',
    data: {
        labels: <?= json_encode($months) ?>,
        datasets: [{ label: 'إجمالي المبيعات', data: <?= json_encode($monthly_totals) ?>, backgroundColor: 'rgba(13,110,253,0.7)' }]
    }
});

new Chart(document.getElementById('companyInvoices'), {
    type: 'bar',
    data: {
        labels: <?= json_encode($company_labels) ?>,
        datasets: [{ label: 'عدد الفواتير', data: <?= json_encode($company_counts) ?>, backgroundColor: 'rgba(255,193,7,0.7)' }]
    }
});

new Chart(document.getElementById('currencySales'), {
    type: 'doughnut',
    data: {
        labels: <?= json_encode(array_values($currencies)) ?>,
        datasets: [{ label: 'المبيعات', data: <?= json_encode($currency_totals) ?>, backgroundColor: ['rgba(40,167,69,0.7)','rgba(220,53,69,0.7)'] }]
    }
});

new Chart(document.getElementById('topProducts'), {
    type: 'bar',
    data: {
        labels: <?= json_encode($product_labels) ?>,
        datasets: [{ label: 'الكمية المباعة', data: <?= json_encode($product_quantities) ?>, backgroundColor: 'rgba(23,162,184,0.7)' }]
    }
});
</script>

</body>
</html>
