<?php
session_start();
require 'config.php';
include 'navbar.php';
ini_set('display_errors', 1);
error_reporting(E_ALL);

// استقبال المدخلات
$customer_id = $_GET['customer_id'] ?? '';
$new_sale = $_GET['amount'] ?? '';
$result = null;

// جلب جميع العملاء
$customers = $conn->query("SELECT id, name FROM customers ORDER BY name")->fetchAll(PDO::FETCH_ASSOC);

// عند اختيار العميل
if ($customer_id) {
    $cust = $conn->prepare("SELECT id, name, balance, credit_balance FROM customers WHERE id=?");
    $cust->execute([$customer_id]);
    $customer = $cust->fetch(PDO::FETCH_ASSOC);

    if ($customer) {
        $balance = floatval($customer['balance']);
        $credit_raw = trim($customer['credit_balance']);
        $credit_lower = mb_strtolower($credit_raw, 'UTF-8');

        // معالجة الحد الائتماني
        if ($credit_lower === 'مفتوح') {
            $credit_value = INF;
            $credit_label = 'مفتوح';
        } elseif ($credit_lower === 'كاش' || $credit_raw === '' || !is_numeric($credit_raw)) {
            $credit_value = 0;
            $credit_label = 'كاش';
        } else {
            $credit_value = floatval($credit_raw);
            $credit_label = number_format($credit_value, 2);
        }

        // جلب أقرب فاتورة مستحقة
        $q = $conn->prepare("SELECT id, due_date, amount FROM invoices WHERE customer_id=? ORDER BY due_date ASC LIMIT 1");
        $q->execute([$customer_id]);
        $invoice = $q->fetch(PDO::FETCH_ASSOC);

        // حساب الرصيد بعد العملية
        $new_balance = $balance + floatval($new_sale);
        $will_exceed = $new_balance > $credit_value && $credit_value != INF;

        $result = [
            'name' => $customer['name'],
            'balance' => $balance,
            'credit' => $credit_label,
            'new_balance' => $new_balance,
            'status' => $credit_value == INF ? '✅ حساب مفتوح' :
                        ($will_exceed ? '❌ سيتجاوز الحد الائتماني' : '✅ ضمن الحد الائتماني'),
            'invoice' => $invoice
        ];
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تحليل المبيعات والحد الائتماني</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<!-- مكتبة Select2 للبحث داخل القائمة -->
<link href="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/css/select2.min.css" rel="stylesheet" />
<style>
body {background-color:#f7f9fc;}
.card {border-radius:1rem;}
.select2-container--default .select2-selection--single {
  height: 38px; padding: 4px 8px;
}
</style>
</head>
<body class="container mt-4">

<h3 class="mb-4 text-center">🧾 تحليل المبيعات والحد الائتماني</h3>

<!-- نموذج التحليل -->
<form method="get" class="row g-3 mb-4">
  <div class="col-md-6">
    <select name="customer_id" id="customerSelect" class="form-select" required>
      <option value="">اختر العميل</option>
      <?php foreach ($customers as $c): ?>
        <option value="<?= $c['id'] ?>" <?= $c['id']==$customer_id?'selected':''?>><?= htmlspecialchars($c['name']) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-4">
    <input type="number" step="0.01" name="amount" value="<?= htmlspecialchars($new_sale) ?>" class="form-control" placeholder="مبلغ الفاتورة الجديدة" required>
  </div>
  <div class="col-md-2">
    <button class="btn btn-primary w-100">تحليل العملية</button>
  </div>
</form>

<?php if ($result): ?>
<div class="card shadow p-4">
  <h5>👤 <?= htmlspecialchars($result['name']) ?></h5>
  <p><b>الرصيد الحالي:</b> <?= number_format($result['balance'],2) ?></p>
  <p><b>الحد الائتماني:</b> <?= htmlspecialchars($result['credit']) ?></p>
  <p><b>الرصيد بعد العملية (<?= number_format($new_sale,2) ?>):</b> <?= number_format($result['new_balance'],2) ?></p>
  <p><b>النتيجة:</b> <?= $result['status'] ?></p>

  <?php if ($result['invoice']): ?>
    <p><b>أقرب فاتورة مستحقة:</b> <?= htmlspecialchars($result['invoice']['due_date']) ?> — <?= number_format($result['invoice']['amount'],2) ?></p>
  <?php else: ?>
    <p>✅ لا توجد فواتير مستحقة حالياً</p>
  <?php endif; ?>

  <button class="btn btn-outline-secondary btn-sm mt-2" onclick="copyResult()">📋 نسخ التفاصيل</button>
</div>

<script>
function copyResult(){
  const text = `
اسم الزبون: <?= addslashes($result['name']) ?>

الرصيد الحالي: <?= number_format($result['balance'],2) ?>

الحد الائتماني: <?= addslashes($result['credit']) ?>

الرصيد بعد العمليه: <?= number_format($result['new_balance'],2) ?>

النتيجه: <?= addslashes($result['status']) ?>

<?php if ($result['invoice']): ?>
اقرب فاتورة مستحقة: <?= addslashes($result['invoice']['due_date']) ?> — <?= number_format($result['invoice']['amount'],2) ?>
<?php else: ?>
اقرب فاتورة مستحقة: لا توجد فواتير حالياً
<?php endif; ?>
  `;
  navigator.clipboard.writeText(text.trim());
  alert('✅ تم نسخ التفاصيل!');
}
</script>
<?php endif; ?>

<!-- مكتبة Select2 لتفعيل البحث داخل القائمة -->
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<script src="https://cdn.jsdelivr.net/npm/select2@4.1.0-rc.0/dist/js/select2.min.js"></script>
<script>
$(document).ready(function() {
  $('#customerSelect').select2({
    placeholder: "اختر العميل أو اكتب للبحث...",
    dir: "rtl",
    width: '100%'
  });
});
</script>

</body>
</html>
