<?php
require 'config.php';
require __DIR__ . '/vendor/autoload.php';

use Mpdf\Mpdf;

// تفعيل عرض الأخطاء (للتجربة فقط، يفضل إغلاقها في الإنتاج)
ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

// دالة لتفادي مشكلة htmlspecialchars(null)
function h($str){
    return htmlspecialchars($str ?? '', ENT_QUOTES, 'UTF-8');
}

// التحقق من اختيار المندوب
$rep = $_GET['rep'] ?? '';
if (!$rep) {
    die("⚠️ لم يتم اختيار مندوب");
}

// جلب بيانات العملاء والفواتير للمندوب
$stmt = $conn->prepare("
    SELECT c.id, c.name, c.phone, c.credit_limit,
           IFNULL(SUM(i.total),0) as total_invoices
    FROM customers c
    LEFT JOIN invoices i ON c.id = i.customer_id
    WHERE c.representative = :rep
    GROUP BY c.id
");
$stmt->execute(['rep' => $rep]);
$customers = $stmt->fetchAll(PDO::FETCH_ASSOC);

// إعداد mPDF مع مجلد مؤقت آمن
$mpdf = new Mpdf([
    'tempDir' => sys_get_temp_dir(),
    'default_font' => 'dejavusans'
]);

// محتوى الـ PDF
$html = "
<h2 style='text-align:center'>تقرير المندوب: " . h($rep) . "</h2>
<table border='1' cellpadding='6' cellspacing='0' width='100%'>
    <thead>
        <tr style='background:#f0f0f0; text-align:center'>
            <th>العميل</th>
            <th>الهاتف</th>
            <th>الحد الائتماني</th>
            <th>إجمالي الفواتير</th>
            <th>الرصيد</th>
        </tr>
    </thead>
    <tbody>
";

foreach ($customers as $c) {
    $balance = $c['total_invoices'];
    $exceeded = ($balance > $c['credit_limit'] && $c['credit_limit'] > 0);

    $rowStyle = $exceeded ? "style='background-color:#f8d7da;'" : "";

    $html .= "
        <tr $rowStyle>
            <td>".h($c['name'])."</td>
            <td>".h($c['phone'])."</td>
            <td style='text-align:center'>".h($c['credit_limit'])."</td>
            <td style='text-align:center'>".h($c['total_invoices'])."</td>
            <td style='text-align:center'>".h($balance)."</td>
        </tr>
    ";
}

$html .= "</tbody></table>";

// توليد الملف
$mpdf->WriteHTML($html);
$mpdf->Output("report_$rep.pdf", "I");
