<?php
require 'config.php';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = $_POST['name'] ?? '';
    $price = floatval($_POST['price'] ?? 0);
    $unit = $_POST['unit'] ?? '';

    $stmt = $conn->prepare("INSERT INTO products (name, price, unit) VALUES (?, ?, ?)");
    $stmt->execute([$name, $price, $unit]);

    header("Location: index.php");
    exit;
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>إضافة مادة جديدة</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="bg-light">
<div class="container mt-5">
  <div class="card shadow">
    <div class="card-header bg-primary text-white">
      <h4>➕ إضافة مادة جديدة</h4>
    </div>
    <div class="card-body">
      <form method="POST">
        <div class="mb-3">
          <label>اسم المادة</label>
          <input type="text" name="name" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>السعر الفردي ($)</label>
          <input type="number" step="0.01" name="price" class="form-control" required>
        </div>
        <div class="mb-3">
          <label>الوحدة (كغ، قطعة...)</label>
          <input type="text" name="unit" class="form-control">
        </div>
        <button type="submit" class="btn btn-success">💾 حفظ</button>
        <a href="index.php" class="btn btn-secondary">رجوع</a>
      </form>
    </div>
  </div>
</div>
</body>
</html>
