<?php
session_start();
require 'config.php';
require __DIR__ . '/vendor/autoload.php';
use PhpOffice\PhpSpreadsheet\IOFactory;

$message = "";
$results = [];

if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_FILES['file'])) {

    $file = $_FILES['file']['tmp_name'];

    try {
        $spreadsheet = IOFactory::load($file);
        $sheet = $spreadsheet->getActiveSheet();

        // قراءة رؤوس الأعمدة
        $headers = [];
        foreach ($sheet->getColumnIterator() as $col) {
            $colIndex = $col->getColumnIndex();
            $headerValue = trim($sheet->getCell($colIndex.'1')->getValue());
            if ($headerValue) $headers[$headerValue] = $colIndex;
        }

        foreach ($sheet->getRowIterator() as $rowIndex => $row) {

            if ($rowIndex == 1) continue; // تجاهل رؤوس الأعمدة

            // قراءة بيانات العميل
            $name  = trim($sheet->getCell($headers['الاسم'] . $rowIndex)->getValue());
            $new_balance = floatval($sheet->getCell($headers['الرصيد'] . $rowIndex)->getValue());

            if (!$name) continue;

            // جلب بيانات العميل من DB
            $stmt = $conn->prepare("SELECT * FROM customers WHERE name=?");
            $stmt->execute([$name]);
            $customer = $stmt->fetch(PDO::FETCH_ASSOC);

            if (!$customer) continue;

            $customer_id = $customer['id'];
            $representative = $customer['representative'];

            // جلب snapshot السابق
            $snap = $conn->prepare("SELECT * FROM balance_snapshot WHERE customer_id=?");
            $snap->execute([$customer_id]);
            $snapshot = $snap->fetch(PDO::FETCH_ASSOC);

            if ($snapshot) {
                $old_balance = $snapshot['last_balance'];
            } else {
                $old_balance = $customer['balance']; // أول مرة
            }

            // جلب فواتير هذا اليوم لهذا العميل
            $today = date('Y-m-d');
            $inv = $conn->prepare("SELECT SUM(amount) FROM invoices WHERE customer_id=? AND DATE(created_at)=?");
            $inv->execute([$customer_id, $today]);
            $invoices_today = floatval($inv->fetchColumn());

            // حساب الفرق
            $difference = $new_balance - $old_balance;

            $sales_detected = 0;
            $payment_detected = 0;

            if ($difference > 0) {
                // رصيد زاد → هذا شراء (فاتورة)
                $sales_detected = $difference;
            } elseif ($difference < 0) {
                // رصيد نقص → هذا قبض
                $payment_detected = abs($difference);
            }

            // مزامنة snapshot الجديد
            if ($snapshot) {
                $update = $conn->prepare("UPDATE balance_snapshot SET last_balance=?, last_update=NOW() WHERE customer_id=?");
                $update->execute([$new_balance, $customer_id]);
            } else {
                $insert = $conn->prepare("INSERT INTO balance_snapshot (customer_id,last_balance,last_update) VALUES (?,?,NOW())");
                $insert->execute([$customer_id, $new_balance]);
            }

            // حفظ الحركة في movement_log
            $log = $conn->prepare("
                INSERT INTO movement_log
                (customer_id, customer_name, representative, old_balance, new_balance,
                 invoices_added_today, payment_detected, sales_detected, difference, log_time)
                VALUES (?,?,?,?,?,?,?,?,?,NOW())
            ");
            $log->execute([
                $customer_id, $name, $representative,
                $old_balance, $new_balance, $invoices_today,
                $payment_detected, $sales_detected, $difference
            ]);

            // عرض في الصفحة
            $results[] = [
                'name' => $name,
                'rep' => $representative,
                'old_balance' => $old_balance,
                'new_balance' => $new_balance,
                'inv_today' => $invoices_today,
                'sales' => $sales_detected,
                'payment' => $payment_detected,
                'diff' => $difference
            ];
        }

        $message = "✔ تم تحليل الملف بنجاح";

    } catch (Exception $e) {
        $message = "❌ خطأ: " . $e->getMessage();
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>تحليل حركة العملاء</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>
<body class="container mt-4">

<h2 class="text-center mb-4">📊 تحليل حركة العملاء</h2>

<?php if($message) echo "<div class='alert alert-info'>$message</div>"; ?>

<form method="post" enctype="multipart/form-data" class="mb-4">
    <input type="file" name="file" class="form-control" required>
    <button class="btn btn-primary mt-2">رفع وتحليل</button>
</form>

<?php if(!empty($results)): ?>

<table class="table table-bordered table-striped text-center">
<thead class="table-dark">
<tr>
    <th>العميل</th>
    <th>المندوب</th>
    <th>الرصيد القديم</th>
    <th>الرصيد الجديد</th>
    <th>فواتير اليوم</th>
    <th>مبيعات مكتشفة</th>
    <th>قبض مكتشف</th>
    <th>الفرق</th>
</tr>
</thead>
<tbody>
<?php foreach($results as $r): ?>
<tr>
    <td><?= $r['name'] ?></td>
    <td><?= $r['rep'] ?></td>
    <td><?= number_format($r['old_balance'],2) ?></td>
    <td><?= number_format($r['new_balance'],2) ?></td>
    <td><?= number_format($r['inv_today'],2) ?></td>
    <td class="text-success"><?= number_format($r['sales'],2) ?></td>
    <td class="text-danger"><?= number_format($r['payment'],2) ?></td>
    <td><?= number_format($r['diff'],2) ?></td>
</tr>
<?php endforeach; ?>
</tbody>
</table>

<?php endif; ?>

</body>
</html>
