<?php
require 'config.php';
include 'navbar.php';
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

// فلترة العملاء والفواتير
$filter_rep    = $_GET['representative'] ?? '';
$filter_status = $_GET['status'] ?? '';
$filter_date   = $_GET['filter_date'] ?? '';
$order_by      = $_GET['order_by'] ?? 'balance';

// فلترة بالتاريخ اليدوي (من – إلى)
$start_date = $_GET['start_date'] ?? '';
$end_date   = $_GET['end_date'] ?? '';

// جلب العملاء
$sql = "SELECT * FROM customers WHERE 1";
$params = [];
if($filter_rep !== ''){
    $sql .= " AND representative=?";
    $params[] = $filter_rep;
}
$sql .= $order_by==='balance'?" ORDER BY balance DESC":" ORDER BY name ASC";
$stmt = $conn->prepare($sql);
$stmt->execute($params);
$customers_all = $stmt->fetchAll(PDO::FETCH_ASSOC);

// قائمة المندوبين
$reps = $conn->query("SELECT DISTINCT representative FROM customers WHERE representative IS NOT NULL AND representative != ''")->fetchAll(PDO::FETCH_COLUMN);

// دالة فلترة التواريخ
function inDateFilter($date, $filter, $start_date='', $end_date=''){
    $time = strtotime($date);
    $today = strtotime(date('Y-m-d'));

    // فلترة بالمدى الزمني اليدوي
    if($start_date && $end_date){
        return $time >= strtotime($start_date) && $time <= strtotime($end_date);
    }

    switch($filter){
        case 'today': return date('Y-m-d',$time)===date('Y-m-d',$today);
        case 'this_week': return $time>=strtotime("monday this week") && $time<=strtotime("sunday this week");
        case 'two_weeks': return $time>=strtotime("-2 weeks monday") && $time<=strtotime("sunday this week");
        case 'this_month': return date('Y-m',$time)===date('Y-m',$today);
        default: return true;
    }
}

// فلترة العملاء حسب الفلاتر
$customers = [];
foreach($customers_all as $c){
    $stmt2 = $conn->prepare("SELECT * FROM invoices WHERE customer_id=? ORDER BY due_date ASC");
    $stmt2->execute([$c['id']]);
    $invoices_all = $stmt2->fetchAll(PDO::FETCH_ASSOC);

    // فلترة الفواتير للعرض أولاً
    $invoices_filtered = [];
    foreach($invoices_all as $inv){
        if(inDateFilter($inv['due_date'],$filter_date,$start_date,$end_date)) $invoices_filtered[] = $inv;
    }

    // مجموع الفواتير بعد الفلترة فقط
    $total_invoices_filtered = array_sum(array_column($invoices_filtered,'amount'));

    // حالة الرصيد مقابل الفواتير المفلترة فقط
    $c['account_status'] = ($c['balance'] != $total_invoices_filtered) ? "تحديث مطلوب" : "";

    // الفرق بين الرصيد ومجموع الفواتير
    $c['balance_diff'] = $c['balance'] - $total_invoices_filtered;

    // تحقق من فلاتر التأخر
    if($filter_status==='overdue'){
        $invoices_filtered = array_filter($invoices_filtered, function($inv){
            return strtotime($inv['due_date']) < time();
        });
        if(empty($invoices_filtered)) continue; // تجاهل العميل إذا لا توجد فواتير متأخرة
    }

    // إذا تم تحديد مدى زمني وتبين أن العميل لا يملك فواتير في هذا المدى → تجاهله
    if($start_date && $end_date && empty($invoices_filtered)) continue;

    $c['filtered_invoices'] = $invoices_filtered;
    $c['total_invoices_all'] = $total_invoices_filtered;
    $customers[] = $c;
}

// جمع الفواتير بعد الفلترة
$total_filtered = 0;
foreach($customers as $c){
    foreach($c['filtered_invoices'] as $inv){
        $total_filtered += $inv['amount'];
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>المستحقات</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
.overdue {background-color:#f8d7da;}
.table td input {width:90px;}
.add-invoice-form input, .add-invoice-form button {margin-bottom:4px;}
</style>
</head>
<body class="container mt-4">

<h2 class="mb-4 text-center">📊 المستحقات والفواتير</h2>

<!-- الفلاتر والخيارات -->
<form method="get" class="row mb-3 g-2">
  <div class="col-md-2">
    <select name="representative" class="form-select">
      <option value="">كل المندوبين</option>
      <?php foreach($reps as $rep): ?>
      <option value="<?= htmlspecialchars($rep) ?>" <?= $filter_rep===$rep?'selected':'' ?>><?= htmlspecialchars($rep) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-2">
    <select name="status" class="form-select">
      <option value="">كل العملاء</option>
      <option value="overdue" <?= $filter_status==='overdue'?'selected':'' ?>>فواتير متأخرة</option>
    </select>
  </div>
  <div class="col-md-2">
    <select name="filter_date" class="form-select">
      <option value="">كل الفواتير</option>
      <option value="today" <?= $filter_date==='today'?'selected':'' ?>>فواتير اليوم</option>
      <option value="this_week" <?= $filter_date==='this_week'?'selected':'' ?>>فواتير هذا الأسبوع</option>
      <option value="two_weeks" <?= $filter_date==='two_weeks'?'selected':'' ?>>فواتير الأسبوعين</option>
      <option value="this_month" <?= $filter_date==='this_month'?'selected':'' ?>>فواتير هذا الشهر</option>
    </select>
  </div>
  <div class="col-md-2">
    <select name="order_by" class="form-select">
      <option value="balance" <?= $order_by==='balance'?'selected':'' ?>>ترتيب حسب الرصيد</option>
      <option value="name" <?= $order_by==='name'?'selected':'' ?>>ترتيب حسب الاسم</option>
    </select>
  </div>
  <!-- التاريخ من – إلى -->
  <div class="col-md-2">
    <input type="date" name="start_date" value="<?= htmlspecialchars($start_date) ?>" class="form-control" placeholder="من تاريخ">
  </div>
  <div class="col-md-2">
    <input type="date" name="end_date" value="<?= htmlspecialchars($end_date) ?>" class="form-control" placeholder="إلى تاريخ">
  </div>
  <div class="col-md-12">
    <button type="submit" class="btn btn-primary w-100">تطبيق</button>
  </div>
</form>

<!-- زر إلغاء الفلترة الزمنية -->
<div class="mb-3">
  <a href="?representative=<?= htmlspecialchars($filter_rep) ?>&status=<?= htmlspecialchars($filter_status) ?>&order_by=<?= htmlspecialchars($order_by) ?>" class="btn btn-warning">إلغاء الفلترة الزمنية</a>
</div>

<div class="mb-2">
<strong>مجموع الفواتير بعد الفلترة: <?= number_format($total_filtered,2) ?></strong>
</div>

<div class="mb-3">
<button id="copy_text" class="btn btn-secondary">نسخ اسم العميل والمبلغ فقط</button>
</div>

<!-- جدول العملاء والفواتير -->
<table class="table table-bordered table-striped text-center">
<thead class="table-dark">
<tr>
<th>الاسم</th>
<th>الرصيد</th>
<th>المندوب</th>
<th>الحالة</th>
<th>الفرق</th>
<th>الفواتير</th>
<th>إضافة فاتورة</th>
</tr>
</thead>
<tbody>
<?php
if(empty($customers)) echo "<tr><td colspan='7'>⚠️ لا توجد بيانات</td></tr>";

foreach($customers as $c){
    echo "<tr>";
    echo "<td>".htmlspecialchars($c['name'] ?? '')."</td>";
    echo "<td>".number_format($c['balance'],2)."</td>";
    echo "<td>".htmlspecialchars($c['representative'] ?? '')."</td>";
    echo "<td>".($c['account_status'] ?? '')."</td>";
    echo "<td>".number_format($c['balance_diff'],2)."</td>";

    echo "<td>";
    if(empty($c['filtered_invoices'])) echo "لا توجد فواتير";
    else{
        echo "<table class='table table-sm'>";
        foreach($c['filtered_invoices'] as $inv){
            $overdue_class = (strtotime($inv['due_date']) < time()) ? "overdue" : "";
            echo "<tr class='$overdue_class'>";
            echo "<td>".htmlspecialchars($inv['due_date'])."</td>";
            echo "<td>".number_format($inv['amount'],2)."</td>";
            echo "<td>
            <button class='btn btn-sm btn-primary edit-invoice' data-id='{$inv['id']}'>تعديل</button>
            <button class='btn btn-sm btn-danger delete-invoice' data-id='{$inv['id']}'>حذف</button>
            </td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    echo "</td>";

    echo "<td>
    <form class='add-invoice-form' data-customer='{$c['id']}'>
    <input type='number' step='0.01' name='amount' placeholder='المبلغ' required class='form-control mb-1'>
    <input type='date' name='due_date' required class='form-control mb-1'>
    <button type='submit' class='btn btn-success btn-sm w-100'>💾 إضافة</button>
    </form>
    </td>";

    echo "</tr>";
}
?>
</tbody>
</table>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script>
// إضافة فاتورة
$('.add-invoice-form').on('submit', function(e){
    e.preventDefault();
    let form = $(this);
    let customer_id = form.data('customer');
    let amount = form.find('input[name=amount]').val();
    let due_date = form.find('input[name=due_date]').val();
    $.post('invoice_actions.php', {action:'add',customer_id,amount,due_date}, function(){ location.reload(); });
});

// حذف فاتورة
$('.delete-invoice').on('click', function(){
    if(!confirm('هل تريد حذف الفاتورة؟')) return;
    let id = $(this).data('id');
    $.post('invoice_actions.php',{action:'delete',id}, function(){ location.reload(); });
});

// تعديل فاتورة
$('.edit-invoice').on('click', function(){
    let id = $(this).data('id');
    let new_amount = prompt('أدخل المبلغ الجديد:');
    let new_date = prompt('أدخل تاريخ الاستحقاق الجديد (YYYY-MM-DD):');
    if(new_amount && new_date){
        $.post('invoice_actions.php',{action:'edit',id,new_amount,new_date}, function(){ location.reload(); });
    }
});

// نسخ اسم العميل ومجموع فواتيره فقط
$('#copy_text').click(function(){
    let text = "";
    let grand_total = 0;

    $('tbody tr').each(function(){
        let name = $(this).find('td:first').text().trim();
        let sub_table = $(this).find('td:nth-child(6) table');
        let customer_total = 0;

        if(sub_table.length){
            sub_table.find('tr').each(function(){
                let amount_td = $(this).find('td:nth-child(2)');
                if(amount_td.length){
                    let amount = parseFloat(amount_td.text().trim().replace(/,/g,''));
                    if(!isNaN(amount) && amount >= 35){
                        customer_total += amount;
                    }
                }
            });
        }

        if(customer_total > 0){
            text += name + " - " + customer_total.toFixed(2) + "\n";
            grand_total += customer_total;
        }
    });

    if(text === ""){
        alert("⚠️ لا توجد بيانات للنسخ!");
        return;
    }

    text += "\nإجمالي جميع العملاء: " + grand_total.toFixed(2);

    navigator.clipboard.writeText(text).then(function(){
        alert("✅ تم نسخ المبالغ المجمعة بنجاح!");
    }, function(){
        alert("حدث خطأ أثناء النسخ.");
    });
});

</script>
</body>
</html>
