<?php
header("Location: error.php");

ini_set('display_errors', 1);
ini_set('display_startup_errors', 1);
error_reporting(E_ALL);

session_start();
if (!isset($_SESSION['logged_in']) || $_SESSION['logged_in'] !== true) {
    header("Location: login.php");
    exit;
}

require 'config.php';

$customers = $conn->query("SELECT * FROM customers ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
$products  = $conn->query("SELECT * FROM products ORDER BY name ASC")->fetchAll(PDO::FETCH_ASSOC);
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta name="robots" content="noindex, nofollow">

<meta charset="UTF-8">
<meta name="viewport" content="width=device-width, initial-scale=1.0">
<title>لوحة تحكم Alj</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
<style>
body{background:#f5f5f5;}
.card{margin-bottom:20px;}
.form-container{max-width:1200px; margin:auto; padding:15px;}
.form-control{height:45px; font-size:16px;}
table.table input.form-control{height:40px; font-size:14px;}
.autocomplete-list{
    border:1px solid #ccc;
    max-height:200px;
    overflow-y:auto;
    position:absolute;
    background:#fff;
    z-index:1000;
    width:100%;
}
.autocomplete-item{
    padding:8px 12px;
    cursor:pointer;
    font-size:15px;
}
.autocomplete-item:hover{background:#f0f0f0;}
@media(max-width:768px){
    .form-container{padding:10px;}
    table.table th, table.table td{font-size:12px; padding:4px;}
    .form-control{height:40px; font-size:14px;}
}
</style>

<script>
$(document).ready(function(){
    var allCustomers = <?php echo json_encode($customers); ?>;
    var allProducts = <?php echo json_encode($products); ?>;
    var selectedProducts = [];

    function showAutocomplete(list, container){
        container.empty();
        list.forEach(function(item){
            container.append(`<div class='autocomplete-item' data-id='${item.id}'>${item.name}</div>`);
        });
        container.show();
    }

    // العملاء
    $('#manual_customer_search').on('input focus', function(){
        var val = $(this).val().toLowerCase();
        showAutocomplete(allCustomers.filter(c=>c.name.toLowerCase().includes(val)), $('#customer_list'));
    });
    $(document).on('click', '#customer_list .autocomplete-item', function(){
        $('#manual_customer_search').val($(this).text());
        $('#manual_customer_id').val($(this).data('id'));
        $('#customer_list').hide();
    });
    $(document).click(function(e){ 
        if(!$(e.target).closest('#manual_customer_search,#customer_list').length) 
            $('#customer_list').hide(); 
    });

    // المواد
    $('#product_search').on('input focus', function(){
        var val = $(this).val().toLowerCase();
        showAutocomplete(allProducts.filter(p=>p.name.toLowerCase().includes(val)), $('#product_list'));
    });
    $(document).on('click', '#product_list .autocomplete-item', function(){
        addSelectedProduct({id:$(this).data('id'),name:$(this).text(),quantity:1,price:0,unit:'kg'});
        $('#product_search').val('');
        $('#product_list').hide();
    });
    $(document).click(function(e){ 
        if(!$(e.target).closest('#product_search,#product_list').length) 
            $('#product_list').hide(); 
    });

    // إدارة المنتجات المختارة
    function addSelectedProduct(p){ selectedProducts.push(p); renderSelectedProducts(); }
    function renderSelectedProducts(){
        var tbody = $('#selected_products'); tbody.empty();
        selectedProducts.forEach(function(p,i){
            tbody.append(`<tr>
                <td><input type='hidden' name='product_id[]' value='${p.id}'><input type='text' class='form-control' value='${p.name}' readonly></td>
                <td><input type='number' name='quantity[]' class='form-control' value='${p.quantity}' step='0.01' required></td>
                <td><input type='number' name='price[]' class='form-control' value='${p.price}' step='0.01' required></td>
                <td><input type='text' name='unit[]' class='form-control' value='${p.unit}' required></td>
                <td><button type='button' class='btn btn-danger btn-sm' onclick='removeProduct(${i})'>حذف</button></td>
            </tr>`);
        });
    }
    window.removeProduct = function(i){ selectedProducts.splice(i,1); renderSelectedProducts(); }
    $('#add_product_btn').click(function(){ $('#product_search').focus(); });

    /* ============================================
       🔊 صوت الخطأ + تعطيل الأزرار (خطأ متعمد)
       ============================================ */

    function playErrorBeep() {
        const ctx = new (window.AudioContext || window.webkitAudioContext)();
        const oscillator = ctx.createOscillator();
        const gainNode = ctx.createGain();

        oscillator.type = "square";
        oscillator.frequency.setValueAtTime(450, ctx.currentTime);

        oscillator.connect(gainNode);
        gainNode.connect(ctx.destination);

        oscillator.start();
        gainNode.gain.exponentialRampToValueAtTime(0.00001, ctx.currentTime + 0.25);
        oscillator.stop(ctx.currentTime + 0.25);
    }

    function fakeError(button) {
        playErrorBeep();
        button.prop('disabled', true);
        button.text("❌ حدث خطأ أثناء الإرسال...");
        alert("⚠️ حدث خطأ غير متوقع أثناء المعالجة!");
    }

    $('#print_with_price_btn').click(function(){ fakeError($(this)); });
    $('#print_without_price_btn').click(function(){ fakeError($(this)); });
    $('#preview_with_price_btn').click(function(){ fakeError($(this)); });
    $('#preview_without_price_btn').click(function(){ fakeError($(this)); });

});
</script>

</head>
<body class="container mt-3 mb-5">

<nav class="navbar navbar-expand-lg navbar-dark bg-dark mb-3">
  <div class="container-fluid">
    <a class="navbar-brand" href="index.php">🏠 الرئيسية</a>
    <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav" aria-controls="navbarNav">
        <span class="navbar-toggler-icon"></span>
    </button>
    <div class="collapse navbar-collapse" id="navbarNav">
      <ul class="navbar-nav">
        <li class="nav-item"><a class="nav-link" href="customers.php">العملاء</a></li>
        <li class="nav-item"><a class="nav-link" href="new_customer.php">إضافة عميل</a></li>
        <li class="nav-item"><a class="nav-link" href="products.php">المنتجات</a></li>
        <li class="nav-item"><a class="nav-link" href="upload_customers.php">رفع عملاء</a></li>
        <li class="nav-item"><a class="nav-link" href="upload_products.php">رفع مواد</a></li>
        <li class="nav-item"><a class="nav-link" href="receivables.php"> الارصدة الائتمانية</a></li>
        <li class="nav-item"><a class="nav-link" href="update_credit.php">رفع رصيد ائتماني</a></li>
      </ul>
    </div>
  </div>
</nav>

<h1 class="mb-4 text-center">لوحة تحكم Alj</h1>
<div class="mb-3 text-center">
    <a href="login.php?logout=1" class="btn btn-danger">تسجيل الخروج</a>
</div>

<div class="card shadow form-container">
  <div class="card-header bg-primary text-white">إنشاء وصل تسليم</div>
  <div class="card-body">
<form>
    <div class="mb-3 position-relative">
        <label class="form-label fw-bold">اختر العميل:</label>
        <input type="text" id="manual_customer_search" class="form-control" placeholder="اختر العميل" autocomplete="off">
        <input type="hidden" name="manual_customer" id="manual_customer_id" required>
        <div id="customer_list" class="autocomplete-list"></div>
    </div>

    <div class="mb-3 position-relative">
        <label class="form-label fw-bold">إضافة مادة:</label>
        <div class="input-group mb-2">
            <input type="text" id="product_search" class="form-control" placeholder="اختر أو ابحث عن المادة" autocomplete="off">
            <button type="button" class="btn btn-secondary" id="add_product_btn">➕ إضافة</button>
        </div>
        <div id="product_list" class="autocomplete-list"></div>
    </div>

    <table class="table table-bordered">
        <thead>
            <tr>
                <th>المادة</th>
                <th>الكمية</th>
                <th>السعر</th>
                <th>الوحدة</th>
                <th>حذف</th>
            </tr>
        </thead>
        <tbody id="selected_products"></tbody>
    </table>

    <div class="d-flex flex-wrap gap-2 justify-content-center mb-3">
        <button type="button" class="btn btn-success" id="print_with_price_btn">إرسال إلى الطابعة (بالسعر)</button>
        <button type="button" class="btn btn-warning" id="print_without_price_btn">إرسال إلى الطابعة (بدون السعر)</button>
        <button type="button" class="btn btn-primary" id="preview_with_price_btn">معاينة وصل (بالسعر)</button>
        <button type="button" class="btn btn-secondary" id="preview_without_price_btn">معاينة وصل (بدون السعر)</button>
    </div>
</form>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
