<?php
require 'config.php';
include 'navbar.php';
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

// فلترة العملاء والفواتير
$filter_rep = $_GET['representative'] ?? '';
$filter_status = $_GET['status'] ?? '';
$filter_date = $_GET['filter_date'] ?? '';
$order_by = $_GET['order_by'] ?? 'balance';

// جلب العملاء
$sql = "SELECT * FROM customers WHERE 1";
$params = [];
if($filter_rep !== ''){
    $sql .= " AND representative=?";
    $params[] = $filter_rep;
}
$sql .= $order_by==='balance'?" ORDER BY balance DESC":" ORDER BY name ASC";
$stmt = $conn->prepare($sql);
$stmt->execute($params);
$customers = $stmt->fetchAll(PDO::FETCH_ASSOC);

// قائمة المندوبين
$reps = $conn->query("SELECT DISTINCT representative FROM customers WHERE representative IS NOT NULL AND representative != ''")->fetchAll(PDO::FETCH_COLUMN);

// دالة فلترة التواريخ
function inDateFilter($date, $filter){
    $time = strtotime($date);
    $today = strtotime(date('Y-m-d'));
    switch($filter){
        case 'today': return date('Y-m-d',$time)===date('Y-m-d',$today);
        case 'this_week': return $time>=strtotime("monday this week") && $time<=strtotime("sunday this week");
        case 'two_weeks': return $time>=strtotime("-2 weeks monday") && $time<=strtotime("sunday this week");
        case 'this_month': return date('Y-m',$time)===date('Y-m',$today);
        default: return true;
    }
}

// حساب مجموع الفواتير بعد الفلترة
$total_filtered_invoices = 0;
$filtered_customers = [];
foreach($customers as $c){
    $stmt2 = $conn->prepare("SELECT * FROM invoices WHERE customer_id=? ORDER BY due_date ASC");
    $stmt2->execute([$c['id']]);
    $invoices_all = $stmt2->fetchAll(PDO::FETCH_ASSOC);

    // فلترة الفواتير حسب التاريخ
    $invoices = [];
    foreach($invoices_all as $inv){
        if(inDateFilter($inv['due_date'],$filter_date)) $invoices[] = $inv;
    }

    // تحقق من الفلاتر على حالة التأخر
    $has_overdue = false;
    foreach($invoices as $inv){
        if(strtotime($inv['due_date']) < time()) $has_overdue = true;
    }
    if($filter_status==='overdue' && !$has_overdue) continue;

    // فقط أضف العملاء الذين لديهم فواتير بعد الفلترة أو كل العملاء إذا لا يوجد فلتر تاريخي
    if($filter_date===''){
        $filtered_customers[] = $c;
    } else {
        if(!empty($invoices)) $filtered_customers[] = $c;
    }

    // جمع الفواتير بعد الفلترة
    foreach($invoices as $inv){
        $total_filtered_invoices += $inv['amount'];
    }
}
?>

<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>المستحقات</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
.overdue {background-color:#f8d7da;}
.table td input {width:90px;}
.add-invoice-form input, .add-invoice-form button {margin-bottom:4px;}
</style>
</head>
<body class="container mt-4">

<h2 class="mb-3 text-center">📊 المستحقات والفواتير</h2>

<div class="mb-3 d-flex gap-2">
    <button id="copy_with_dates" class="btn btn-secondary">نسخ النص مع التواريخ</button>
    <button id="copy_without_dates" class="btn btn-secondary">نسخ النص بدون تواريخ</button>
    <button id="export_excel" class="btn btn-success">تصدير Excel</button>
</div>

<div class="mb-3 fw-bold">مجموع الفواتير بعد الفلترة: <?= number_format($total_filtered_invoices,2) ?></div>

<!-- فلترة العملاء والفواتير -->
<form method="get" class="row mb-3 g-2">
  <div class="col-md-2">
    <select name="representative" class="form-select">
      <option value="">كل المندوبين</option>
      <?php foreach($reps as $rep): ?>
      <option value="<?= htmlspecialchars($rep) ?>" <?= $filter_rep===$rep?'selected':'' ?>><?= htmlspecialchars($rep) ?></option>
      <?php endforeach; ?>
    </select>
  </div>
  <div class="col-md-2">
    <select name="status" class="form-select">
      <option value="">كل العملاء</option>
      <option value="overdue" <?= $filter_status==='overdue'?'selected':'' ?>>فواتير متأخرة</option>
    </select>
  </div>
  <div class="col-md-2">
    <select name="filter_date" class="form-select">
      <option value="">كل الفواتير</option>
      <option value="today" <?= $filter_date==='today'?'selected':'' ?>>فواتير اليوم</option>
      <option value="this_week" <?= $filter_date==='this_week'?'selected':'' ?>>فواتير هذا الأسبوع</option>
      <option value="two_weeks" <?= $filter_date==='two_weeks'?'selected':'' ?>>فواتير الأسبوعين</option>
      <option value="this_month" <?= $filter_date==='this_month'?'selected':'' ?>>فواتير هذا الشهر</option>
    </select>
  </div>
  <div class="col-md-2">
    <select name="order_by" class="form-select">
      <option value="balance" <?= $order_by==='balance'?'selected':'' ?>>ترتيب حسب الرصيد</option>
      <option value="name" <?= $order_by==='name'?'selected':'' ?>>ترتيب حسب الاسم</option>
    </select>
  </div>
  <div class="col-md-4">
    <button type="submit" class="btn btn-primary w-100">تطبيق</button>
  </div>
</form>

<!-- جدول العملاء والفواتير -->
<table class="table table-bordered table-striped text-center">
<thead class="table-dark">
<tr>
<th>الاسم</th>
<th>الرصيد</th>
<th>المندوب</th>
<th>الحالة</th>
<th>الفواتير</th>
<th>إضافة فاتورة</th>
</tr>
</thead>
<tbody>
<?php
if(empty($filtered_customers)) echo "<tr><td colspan='6'>⚠️ لا توجد بيانات</td></tr>";

foreach($filtered_customers as $c){
    $stmt2 = $conn->prepare("SELECT * FROM invoices WHERE customer_id=? ORDER BY due_date ASC");
    $stmt2->execute([$c['id']]);
    $invoices_all = $stmt2->fetchAll(PDO::FETCH_ASSOC);

    // الحالة دائماً حسب الرصيد مقابل كل الفواتير
    $total_invoices_all = array_sum(array_column($invoices_all,'amount'));
    $account_status = ($c['balance'] != $total_invoices_all) ? "تحديث مطلوب" : "";

    // فلترة الفواتير حسب التاريخ للعرض
    $invoices = [];
    foreach($invoices_all as $inv){
        if(inDateFilter($inv['due_date'],$filter_date)) $invoices[] = $inv;
    }

    echo "<tr>";
    echo "<td>".htmlspecialchars($c['name'])."</td>";
    echo "<td>".number_format($c['balance'],2)."</td>";
    echo "<td>".htmlspecialchars($c['representative'])."</td>";
    echo "<td>$account_status</td>";

    echo "<td>";
    if(empty($invoices)) echo "لا توجد فواتير";
    else{
        echo "<table class='table table-sm'>";
        foreach($invoices as $inv){
            $overdue_class = (strtotime($inv['due_date']) < time()) ? "overdue" : "";
            echo "<tr class='$overdue_class'>";
            echo "<td>".htmlspecialchars($inv['due_date'])."</td>";
            echo "<td>".number_format($inv['amount'],2)."</td>";
            echo "<td>
            <button class='btn btn-sm btn-primary edit-invoice' data-id='{$inv['id']}'>تعديل</button>
            <button class='btn btn-sm btn-danger delete-invoice' data-id='{$inv['id']}'>حذف</button>
            </td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    echo "</td>";

    echo "<td>
    <form class='add-invoice-form' data-customer='{$c['id']}'>
    <input type='number' step='0.01' name='amount' placeholder='المبلغ' required class='form-control mb-1'>
    <input type='date' name='due_date' required class='form-control mb-1'>
    <button type='submit' class='btn btn-success btn-sm w-100'>💾 إضافة</button>
    </form>
    </td>";

    echo "</tr>";
}
?>
</tbody>
</table>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
<script src="https://code.jquery.com/jquery-3.7.0.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>
<script>
// إضافة فاتورة
$('.add-invoice-form').on('submit', function(e){
    e.preventDefault();
    let form = $(this);
    let customer_id = form.data('customer');
    let amount = form.find('input[name=amount]').val();
    let due_date = form.find('input[name=due_date]').val();
    $.post('invoice_actions.php', {action:'add',customer_id,amount,due_date}, function(){ location.reload(); });
});

// حذف فاتورة
$('.delete-invoice').on('click', function(){
    if(!confirm('هل تريد حذف الفاتورة؟')) return;
    let id = $(this).data('id');
    $.post('invoice_actions.php',{action:'delete',id}, function(){ location.reload(); });
});

// تعديل فاتورة
$('.edit-invoice').on('click', function(){
    let id = $(this).data('id');
    let new_amount = prompt('أدخل المبلغ الجديد:');
    let new_date = prompt('أدخل تاريخ الاستحقاق الجديد (YYYY-MM-DD):');
    if(new_amount && new_date){
        $.post('invoice_actions.php',{action:'edit',id,new_amount,new_date}, function(){ location.reload(); });
    }
});

// نسخ النص
function copyText(with_dates){
    let text = "";
    $('tbody tr').each(function(){
        let name = $(this).find('td:nth-child(1)').text().trim();
        $(this).find('td:nth-child(5) table tr').each(function(){
            let amount = $(this).find('td:nth-child(2)').text().trim();
            let due = $(this).find('td:nth-child(1)').text().trim();
            text += name + " - " + amount;
            if(with_dates) text += " - " + due;
            text += "\n";
        });
    });
    navigator.clipboard.writeText(text);
}

$('#copy_with_dates').click(()=>copyText(true));
$('#copy_without_dates').click(()=>copyText(false));

// تصدير Excel
$('#export_excel').click(function(){
    let ws_data = [];
    $('tbody tr').each(function(){
        let name = $(this).find('td:nth-child(1)').text().trim();
        let balance = parseFloat($(this).find('td:nth-child(2)').text().trim());
        let rep = $(this).find('td:nth-child(3)').text().trim();
        let status = $(this).find('td:nth-child(4)').text().trim();
        $(this).find('td:nth-child(5) table tr').each(function(){
            let due = $(this).find('td:nth-child(1)').text().trim();
            let amount = parseFloat($(this).find('td:nth-child(2)').text().trim());
            ws_data.push([name,balance,rep,status,due,amount]);
        });
    });
    let wb = XLSX.utils.book_new();
    let ws = XLSX.utils.aoa_to_sheet(ws_data);
    XLSX.utils.book_append_sheet(wb,ws,'Invoices');
    XLSX.writeFile(wb,'invoices.xlsx');
});
</script>
</body>
</html>
