<?php
session_start();
require 'config.php';
if(!isset($_SESSION['logged_in'])){
    header("Location: login.php?redirect=customers_dashboard.php");
    exit;
}

// جلب بيانات الفواتير والعملاء
$stmt = $conn->query("
    SELECT c.representative, c.name AS customer_name, i.amount, i.due_date
    FROM invoices i
    JOIN customers c ON i.customer_id = c.id
");
$rows = $stmt->fetchAll(PDO::FETCH_ASSOC);

$total_debt = 0;
$total_overdue = 0;
$by_rep = [];

foreach($rows as $r){
    $amount = floatval($r['amount']);
    $total_debt += $amount;
    $is_overdue = strtotime($r['due_date']) < time();

    if($is_overdue) $total_overdue += $amount;

    $rep = $r['representative'] ?: 'بدون مندوب';
    if(!isset($by_rep[$rep])){
        $by_rep[$rep] = ['total'=>0,'overdue'=>0];
    }

    $by_rep[$rep]['total'] += $amount;
    if($is_overdue) $by_rep[$rep]['overdue'] += $amount;
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
<meta charset="UTF-8">
<title>لوحة الديون</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<style>
.card-box {
    border-radius:10px; 
    padding:20px; 
    color:#fff; 
    text-align:center; 
    font-weight:bold;
}
.bg-debt {background:#0d6efd;}
.bg-overdue {background:#dc3545;}
.table td, .table th {vertical-align: middle;}
</style>
</head>
<body class="container mt-4">

<h3 class="text-center mb-4">📊 لوحة الديون العامة</h3>

<div class="row g-3 mb-4">
    <div class="col-md-6">
        <div class="card-box bg-debt">
            🧾 الدين العام<br>
            <span style="font-size:24px"><?= number_format($total_debt,2) ?> ₺</span>
        </div>
    </div>
    <div class="col-md-6">
        <div class="card-box bg-overdue">
            ⏰ الرصيد المستحق (فواتير متأخرة)<br>
            <span style="font-size:24px"><?= number_format($total_overdue,2) ?> ₺</span>
        </div>
    </div>
</div>

<h5 class="mb-3 text-center">المستحقات حسب المندوب</h5>

<table class="table table-bordered text-center align-middle">
<thead class="table-dark">
<tr>
    <th>المندوب</th>
    <th>إجمالي الدين</th>
    <th>الدين المستحق</th>
    <th>النسبة %</th>
</tr>
</thead>
<tbody>
<?php foreach($by_rep as $rep => $vals): 
    $percent = ($vals['total']>0) ? ($vals['overdue']/$vals['total']*100) : 0;
?>
<tr>
    <td><?= htmlspecialchars($rep) ?></td>
    <td><?= number_format($vals['total'],2) ?></td>
    <td><?= number_format($vals['overdue'],2) ?></td>
    <td>
        <div class="progress" style="height:20px;">
            <div class="progress-bar bg-danger" role="progressbar" style="width:<?= $percent ?>%">
                <?= number_format($percent,1) ?>%
            </div>
        </div>
    </td>
</tr>
<?php endforeach; ?>
</tbody>
</table>

<div class="mt-5">
    <canvas id="chart"></canvas>
</div>

<script>
// رسم بياني يوضح المستحقات لكل مندوب
const ctx = document.getElementById('chart');
const data = {
    labels: <?= json_encode(array_keys($by_rep), JSON_UNESCAPED_UNICODE) ?>,
    datasets: [
        {
            label: 'إجمالي الدين',
            data: <?= json_encode(array_column($by_rep,'total')) ?>,
            backgroundColor: '#0d6efd'
        },
        {
            label: 'الدين المستحق',
            data: <?= json_encode(array_column($by_rep,'overdue')) ?>,
            backgroundColor: '#dc3545'
        }
    ]
};
new Chart(ctx, {
    type: 'bar',
    data: data,
    options: {
        plugins:{legend:{display:true, position:'bottom'}},
        scales:{y:{beginAtZero:true}}
    }
});
</script>

</body>
</html>
