<?php
require 'config.php';

// استلام اسم المندوب من الرابط
$rep = $_GET['rep'] ?? '';
if ($rep == '') die("❌ لم يتم تحديد المندوب");

// إعداد الهيدر ليتم تحميله كملف تقويم
header('Content-Type: text/calendar; charset=utf-8');
header("Content-Disposition: inline; filename=\"calendar_$rep.ics\"");

// رأس ملف التقويم
echo "BEGIN:VCALENDAR\r\n";
echo "VERSION:2.0\r\n";
echo "CALSCALE:GREGORIAN\r\n";
echo "METHOD:PUBLISH\r\n";
echo "X-WR-CALNAME: فواتير المندوب $rep\r\n";
echo "X-WR-TIMEZONE:Europe/Istanbul\r\n";

// جلب الفواتير الخاصة بالمندوب
$stmt = $conn->prepare("
    SELECT invoices.*, customers.name AS customer_name 
    FROM invoices 
    JOIN customers ON invoices.customer_id = customers.id 
    WHERE customers.representative = ?
    ORDER BY invoices.due_date ASC
");
$stmt->execute([$rep]);
$invoices = $stmt->fetchAll(PDO::FETCH_ASSOC);

// إضافة الأحداث (الفواتير) للتقويم
foreach ($invoices as $inv) {
    $uid = uniqid();
    $dt = new DateTime($inv['due_date'], new DateTimeZone('Europe/Istanbul'));
    $date = $dt->format("Ymd"); // يوم كامل بدون ساعات

    $summary = "فاتورة: {$inv['customer_name']} - {$inv['amount']}";

    echo "BEGIN:VEVENT\r\n";
    echo "UID:$uid@deltaweb.agency\r\n";
    echo "DTSTAMP:" . gmdate("Ymd\THis\Z") . "\r\n";
    echo "DTSTART;VALUE=DATE:$date\r\n"; // حدث يوم كامل
    echo "SUMMARY:" . $summary . "\r\n";
    echo "END:VEVENT\r\n";
}

// نهاية الملف
echo "END:VCALENDAR\r\n";
